/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import teamroots.embers.item.IHeldEmberCell;
import teamroots.embers.item.ItemBase;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;

public class ItemEmberCartridge
extends ItemBase
implements IHeldEmberCell {
    public ItemEmberCartridge() {
        super("emberCartridge", true);
        this.func_77625_d(1);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.hasCapability(EmberCapabilityProvider.emberCapability, null) && ((IEmberCapability)stack.getCapability(EmberCapabilityProvider.emberCapability, null)).getEmber() < ((IEmberCapability)stack.getCapability(EmberCapabilityProvider.emberCapability, null)).getEmberCapacity();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(EmberCapabilityProvider.emberCapability, null)) {
            return (((IEmberCapability)stack.getCapability(EmberCapabilityProvider.emberCapability, null)).getEmberCapacity() - ((IEmberCapability)stack.getCapability(EmberCapabilityProvider.emberCapability, null)).getEmber()) / ((IEmberCapability)stack.getCapability(EmberCapabilityProvider.emberCapability, null)).getEmberCapacity();
        }
        return 0.0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new MyEmberProvider();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (stack.hasCapability(EmberCapabilityProvider.emberCapability, null)) {
            tooltip.add("" + ((IEmberCapability)stack.getCapability(EmberCapabilityProvider.emberCapability, null)).getEmber() + " / " + ((IEmberCapability)stack.getCapability(EmberCapabilityProvider.emberCapability, null)).getEmberCapacity());
        }
    }

    public class MyEmberProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<NBTTagCompound> {
        IEmberCapability capability = new DefaultEmberCapability();

        public MyEmberProvider() {
            this.capability.setEmberCapacity(6000.0);
            this.capability.setEmber(0.0);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == EmberCapabilityProvider.emberCapability;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == EmberCapabilityProvider.emberCapability) {
                return (T)this.capability;
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            this.capability.writeToNBT(tag);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.capability.readFromNBT(nbt);
        }
    }
}

