/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageTEUpdate;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityItemPipe;
import teamroots.embers.util.Misc;

public class TileEntityItemPump
extends TileEntity
implements ITileEntityBase,
ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityItemPump.this.func_70296_d();
        }
    };
    public BlockPos lastReceived = new BlockPos(0, 0, 0);
    public int pressure = 16;
    Random random = new Random();
    public EnumPipeConnection up = EnumPipeConnection.NONE;
    public EnumPipeConnection down = EnumPipeConnection.NONE;
    public EnumPipeConnection north = EnumPipeConnection.NONE;
    public EnumPipeConnection south = EnumPipeConnection.NONE;
    public EnumPipeConnection east = EnumPipeConnection.NONE;
    public EnumPipeConnection west = EnumPipeConnection.NONE;

    public static EnumPipeConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumPipeConnection.NONE;
            }
            case 1: {
                return EnumPipeConnection.PIPE;
            }
            case 2: {
                return EnumPipeConnection.BLOCK;
            }
            case 3: {
                return EnumPipeConnection.LEVER;
            }
        }
        return EnumPipeConnection.NONE;
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.DOWN);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.UP);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("lastX", this.lastReceived.func_177958_n());
        tag.func_74768_a("lastY", this.lastReceived.func_177956_o());
        tag.func_74768_a("lastZ", this.lastReceived.func_177952_p());
        tag.func_74768_a("pressure", this.pressure);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityItemPump.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityItemPump.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityItemPump.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityItemPump.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityItemPump.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityItemPump.connectionFromInt(tag.func_74762_e("east"));
        this.lastReceived = new BlockPos(tag.func_74762_e("lastX"), tag.func_74762_e("lastY"), tag.func_74762_e("lastZ"));
        this.pressure = tag.func_74762_e("pressure");
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing face;
        if (world.func_175625_s(pos) instanceof TileEntityItemPipe && !(world.func_175625_s(pos) instanceof TileEntityItemPump)) {
            return EnumPipeConnection.PIPE;
        }
        if (world.func_175625_s(pos) != null && !(world.func_175625_s(pos) instanceof TileEntityItemPump)) {
            if (world.func_175625_s(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
                return EnumPipeConnection.BLOCK;
            }
        } else if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150442_at && ((face = ((BlockLever.EnumOrientation)world.func_180495_p(pos).func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c()) == side || face == EnumFacing.DOWN && side == EnumFacing.UP || face == EnumFacing.UP && side == EnumFacing.DOWN)) {
            return EnumPipeConnection.LEVER;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        if (this.func_145831_w().func_175687_A(this.func_174877_v()) != 0) {
            ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
            ArrayList<EnumFacing> connections = new ArrayList<EnumFacing>();
            if (this.up != EnumPipeConnection.NONE && this.up != EnumPipeConnection.LEVER) {
                connections.add(EnumFacing.UP);
            }
            if (this.down != EnumPipeConnection.NONE && this.down != EnumPipeConnection.LEVER) {
                connections.add(EnumFacing.DOWN);
            }
            if (this.north != EnumPipeConnection.NONE && this.north != EnumPipeConnection.LEVER) {
                connections.add(EnumFacing.NORTH);
            }
            if (this.south != EnumPipeConnection.NONE && this.south != EnumPipeConnection.LEVER) {
                connections.add(EnumFacing.SOUTH);
            }
            if (this.east != EnumPipeConnection.NONE && this.east != EnumPipeConnection.LEVER) {
                connections.add(EnumFacing.EAST);
            }
            if (this.west != EnumPipeConnection.NONE && this.west != EnumPipeConnection.LEVER) {
                connections.add(EnumFacing.WEST);
            }
            for (int i = 0; i < connections.size(); ++i) {
                if (this.func_174877_v().func_177972_a((EnumFacing)connections.get(i)).func_177958_n() != this.lastReceived.func_177958_n() || this.func_174877_v().func_177972_a((EnumFacing)connections.get(i)).func_177956_o() != this.lastReceived.func_177956_o() || this.func_174877_v().func_177972_a((EnumFacing)connections.get(i)).func_177952_p() != this.lastReceived.func_177952_p()) continue;
                connections.remove(i);
                i = Math.max(0, i - 1);
            }
            ArrayList<EnumFacing> blockConnections = new ArrayList<EnumFacing>();
            if (this.up == EnumPipeConnection.BLOCK) {
                blockConnections.add(EnumFacing.UP);
            }
            if (this.down == EnumPipeConnection.BLOCK) {
                blockConnections.add(EnumFacing.DOWN);
            }
            if (this.north == EnumPipeConnection.BLOCK) {
                blockConnections.add(EnumFacing.NORTH);
            }
            if (this.south == EnumPipeConnection.BLOCK) {
                blockConnections.add(EnumFacing.SOUTH);
            }
            if (this.east == EnumPipeConnection.BLOCK) {
                blockConnections.add(EnumFacing.EAST);
            }
            if (this.west == EnumPipeConnection.BLOCK) {
                blockConnections.add(EnumFacing.WEST);
            }
            for (int k = 0; k < 1; ++k) {
                IItemHandler handler;
                TileEntity tile;
                EnumFacing face;
                int i;
                boolean takenItems = false;
                for (i = 0; i < blockConnections.size() && !takenItems; ++i) {
                    face = (EnumFacing)blockConnections.get(i);
                    tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
                    if (tile == null || (handler = (IItemHandler)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) == null) continue;
                    int slot = -1;
                    for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
                        if (handler.getStackInSlot(j) == null || handler.getStackInSlot((int)j).field_77994_a <= 0) continue;
                        slot = j;
                    }
                    if (slot == -1 || this.inventory.getStackInSlot(0) != null) continue;
                    ItemStack extracted = handler.extractItem(slot, 1, false);
                    this.inventory.insertItem(0, extracted, false);
                    this.lastReceived = this.func_174877_v().func_177972_a(face);
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a(face))) {
                        toUpdate.add(this.func_174877_v().func_177972_a(face));
                    }
                    if (!toUpdate.contains(this.func_174877_v())) {
                        toUpdate.add(this.func_174877_v());
                    }
                    takenItems = true;
                }
                if (connections.size() <= 0) continue;
                for (i = 0; i < this.pressure; ++i) {
                    ItemStack extracted;
                    ItemStack added;
                    if (this.inventory.getStackInSlot(0) == null) continue;
                    face = (EnumFacing)connections.get(this.random.nextInt(connections.size()));
                    tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
                    if (!(tile instanceof TileEntityItemPipe)) continue;
                    if (((TileEntityItemPipe)tile).pressure != Math.max(0, this.pressure - 1)) {
                        ((TileEntityItemPipe)tile).pressure = Math.max(0, this.pressure - 1);
                        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(face));
                        toUpdate.add(this.field_174879_c.func_177972_a(face));
                    }
                    if ((handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) == null) continue;
                    ItemStack passStack = new ItemStack(this.inventory.getStackInSlot(0).func_77973_b(), 1, this.inventory.getStackInSlot(0).func_77960_j());
                    if (this.inventory.getStackInSlot(0).func_77942_o()) {
                        passStack.func_77982_d(this.inventory.getStackInSlot(0).func_77978_p());
                    }
                    int slot = -1;
                    for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
                        if (handler.getStackInSlot(j) == null) {
                            slot = j;
                            continue;
                        }
                        if (handler.getStackInSlot((int)j).field_77994_a >= handler.getStackInSlot(j).func_77976_d() || !ItemStack.func_179545_c((ItemStack)handler.getStackInSlot(j), (ItemStack)this.inventory.getStackInSlot(0)) || !ItemStack.func_77970_a((ItemStack)handler.getStackInSlot(j), (ItemStack)this.inventory.getStackInSlot(0))) continue;
                        slot = j;
                    }
                    if (slot == -1 || (added = handler.insertItem(slot, passStack, false)) != null || (extracted = this.inventory.extractItem(0, 1, false)) == null) continue;
                    if (tile instanceof TileEntityItemPipe) {
                        ((TileEntityItemPipe)tile).pressure = Math.max(0, this.pressure - 1);
                        ((TileEntityItemPipe)tile).lastReceived = this.func_174877_v();
                    }
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a(face))) {
                        toUpdate.add(this.func_174877_v().func_177972_a(face));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
            }
            for (int i = 0; i < toUpdate.size(); ++i) {
                this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i)).func_70296_d();
                if (this.func_145831_w().field_72995_K) continue;
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i))));
            }
        }
    }

    public static enum EnumPipeConnection {
        NONE,
        PIPE,
        BLOCK,
        LEVER;

    }
}

