/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageTEUpdate;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityPump;

public class TileEntityPipe
extends TileFluidHandler
implements ITileEntityBase,
ITickable {
    Random random = new Random();
    public EnumPipeConnection up = EnumPipeConnection.NONE;
    public EnumPipeConnection down = EnumPipeConnection.NONE;
    public EnumPipeConnection north = EnumPipeConnection.NONE;
    public EnumPipeConnection south = EnumPipeConnection.NONE;
    public EnumPipeConnection east = EnumPipeConnection.NONE;
    public EnumPipeConnection west = EnumPipeConnection.NONE;

    public static EnumPipeConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumPipeConnection.NONE;
            }
            case 1: {
                return EnumPipeConnection.PIPE;
            }
            case 2: {
                return EnumPipeConnection.BLOCK;
            }
            case 3: {
                return EnumPipeConnection.LEVER;
            }
        }
        return EnumPipeConnection.NONE;
    }

    public TileEntityPipe() {
        this.tank.setCapacity(1000);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.DOWN);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.UP);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityPipe.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityPipe.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityPipe.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityPipe.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityPipe.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityPipe.connectionFromInt(tag.func_74762_e("east"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world.func_175625_s(pos) instanceof TileEntityPipe && !(world.func_175625_s(pos) instanceof TileEntityPump)) {
            return EnumPipeConnection.PIPE;
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return EnumPipeConnection.BLOCK;
        }
        return EnumPipeConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        if (this.tank.getFluid() != null) {
            int i;
            ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
            int distAmount = this.tank.getFluidAmount() / 2;
            ArrayList<EnumFacing> connectedFaces = new ArrayList<EnumFacing>();
            if (this.up == EnumPipeConnection.PIPE || this.up == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.UP);
            }
            if (this.down == EnumPipeConnection.PIPE || this.down == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.DOWN);
            }
            if (this.north == EnumPipeConnection.PIPE || this.north == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.NORTH);
            }
            if (this.south == EnumPipeConnection.PIPE || this.south == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.SOUTH);
            }
            if (this.west == EnumPipeConnection.PIPE || this.west == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.WEST);
            }
            if (this.east == EnumPipeConnection.PIPE || this.east == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.EAST);
            }
            if (connectedFaces.size() > 0) {
                IFluidHandler handler;
                int i2;
                int toEach = distAmount / connectedFaces.size();
                for (i2 = 0; i2 < connectedFaces.size(); ++i2) {
                    if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i2))) == null) continue;
                    handler = (IFluidHandler)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i2))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i2)).func_176734_d());
                    FluidStack toAdd = new FluidStack(this.tank.getFluid().getFluid(), toEach);
                    int filled = handler.fill(toAdd, true);
                    this.tank.drainInternal(new FluidStack(this.tank.getFluid().getFluid(), filled), true);
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i2)))) {
                        toUpdate.add(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i2)));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
                if (this.tank.getFluidAmount() <= connectedFaces.size() || this.tank.getFluidAmount() <= 8) {
                    while (this.tank.getFluidAmount() > 0) {
                        i2 = this.random.nextInt(connectedFaces.size());
                        if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i2))) == null) continue;
                        handler = (IFluidHandler)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i2))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i2)).func_176734_d());
                        int filled = handler.fill(new FluidStack(this.tank.getFluid().getFluid(), 1), true);
                        this.tank.drainInternal(new FluidStack(this.tank.getFluid().getFluid(), filled), true);
                        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                        this.func_70296_d();
                        this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i2))).func_70296_d();
                        if (this.func_145831_w().field_72995_K) continue;
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate((TileEntity)this));
                    }
                }
            }
            connectedFaces.clear();
            if (this.up == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.UP);
            }
            if (this.down == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.DOWN);
            }
            if (this.north == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.NORTH);
            }
            if (this.south == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.SOUTH);
            }
            if (this.west == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.WEST);
            }
            if (this.east == EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.EAST);
            }
            if (connectedFaces.size() > 0) {
                for (i = 0; i < connectedFaces.size() && this.tank.getFluidAmount() > 0; ++i) {
                    if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))) == null) continue;
                    IFluidHandler handler = (IFluidHandler)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d());
                    int filled = handler.fill(new FluidStack(this.tank.getFluid().getFluid(), 1), true);
                    this.tank.drainInternal(new FluidStack(this.tank.getFluid().getFluid(), filled), true);
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)))) {
                        toUpdate.add(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
            }
            for (i = 0; i < toUpdate.size(); ++i) {
                this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i)).func_70296_d();
                if (this.func_145831_w().field_72995_K) continue;
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i))));
            }
        }
    }

    public static enum EnumPipeConnection {
        NONE,
        PIPE,
        BLOCK,
        LEVER;

    }
}

