/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import teamroots.embers.network.message.MessageEmberData;

public class EmberWorldData
extends WorldSavedData {
    public Map<String, Double> emberData = new HashMap<String, Double>();

    public EmberWorldData(String name) {
        super(name);
    }

    public EmberWorldData() {
        super("embers:ember");
    }

    public void func_76184_a(NBTTagCompound tag) {
        if (tag.func_74764_b("embers:emberLocations")) {
            NBTTagList list = tag.func_150295_c("embers:emberLocations", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound location = list.func_150305_b(i);
                this.emberData.put(location.func_74779_i("pos"), location.func_74769_h("value"));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Double> entry : this.emberData.entrySet()) {
            NBTTagCompound location = new NBTTagCompound();
            location.func_74778_a("pos", entry.getKey());
            location.func_74780_a("value", entry.getValue().doubleValue());
            list.func_74742_a((NBTBase)location);
        }
        tag.func_74782_a("embers:emberLocations", (NBTBase)list);
        return tag;
    }

    public void readPacketData(MessageEmberData packet) {
        NBTTagCompound tag = packet.tag;
        if (tag.func_74764_b("embers:emberLocations")) {
            NBTTagList list = tag.func_150295_c("embers:emberLocations", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound location = list.func_150305_b(i);
                this.emberData.put(location.func_74779_i("pos"), location.func_74769_h("value"));
            }
        }
    }

    public ArrayList<MessageEmberData> getData() {
        ArrayList<MessageEmberData> packets = new ArrayList<MessageEmberData>();
        Iterator<Map.Entry<String, Double>> values = this.emberData.entrySet().iterator();
        int i = 0;
        NBTTagList list = new NBTTagList();
        while (values.hasNext()) {
            if (i % 512 == 0) {
                i = 0;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("embers:emberLocations", (NBTBase)list);
                packets.add(new MessageEmberData(tag));
                list = new NBTTagList();
            }
            Map.Entry<String, Double> entry = values.next();
            NBTTagCompound location = new NBTTagCompound();
            location.func_74778_a("pos", entry.getKey());
            location.func_74780_a("value", entry.getValue().doubleValue());
            list.func_74742_a((NBTBase)location);
            ++i;
        }
        return packets;
    }

    public static EmberWorldData get(World world) {
        EmberWorldData data = null;
        if (world != null && (EmberWorldData)world.func_72943_a(EmberWorldData.class, "embers:ember") != null) {
            data = (EmberWorldData)world.func_72943_a(EmberWorldData.class, "embers:ember");
        }
        if (data == null && world != null) {
            data = new EmberWorldData();
            world.func_72823_a("embers:ember", (WorldSavedData)data);
        }
        return data;
    }
}

