/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world.dimension;

public class NoiseGeneratorUtil {
    public static float getNoise(int x, int y) {
        x = 36969 * (x & 0xFFFF) + (x >> 16);
        y = 18000 * (y & 0xFFFF) + (y >> 16);
        return ((float)(x << 16) + (float)y) / 65536.0f;
    }

    public static float fastSin(float x) {
        if ((double)x < -3.14159265) {
            x = (float)((double)x + 6.28318531);
        } else if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        if (x < 0.0f) {
            return (float)(1.27323954 * (double)x + 0.405284735 * (double)x * (double)x);
        }
        return (float)(1.27323954 * (double)x - 0.405284735 * (double)x * (double)x);
    }

    public static float fastCos(float x) {
        if ((double)x < -3.14159265) {
            x = (float)((double)x + 6.28318531);
        } else if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        x = (float)((double)x + 1.57079632);
        if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        if (x < 0.0f) {
            return (float)(1.27323954 * (double)x + 0.405284735 * (double)x * (double)x);
        }
        return (float)(1.27323954 * (double)x - 0.405284735 * (double)x * (double)x);
    }

    public static float interpolate(float s, float e, float t) {
        float t2 = (1.0f - NoiseGeneratorUtil.fastCos(t * (float)Math.PI)) / 2.0f;
        return s * (1.0f - t2) + e * t2;
    }

    public static float bilinear(float ul, float ur, float dr, float dl, float t1, float t2) {
        return NoiseGeneratorUtil.interpolate(NoiseGeneratorUtil.interpolate(ul, ur, t1), NoiseGeneratorUtil.interpolate(dl, dr, t1), t2);
    }

    public static float getOctave(int x, int y, int dimen) {
        return NoiseGeneratorUtil.bilinear(NoiseGeneratorUtil.getNoise(x / dimen * dimen, y / dimen * dimen), NoiseGeneratorUtil.getNoise(x / dimen * dimen + dimen, y / dimen * dimen), NoiseGeneratorUtil.getNoise(x / dimen * dimen + dimen, y / dimen * dimen + dimen), NoiseGeneratorUtil.getNoise(x / dimen * dimen, y / dimen * dimen + dimen), (float)(x - x / dimen * dimen) / (float)dimen, (float)(y - y / dimen * dimen) / (float)dimen);
    }
}

