/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.render.CCModelState;
import codechicken.lib.vec.Matrix4;
import com.google.common.collect.ImmutableMap;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraftforge.common.model.TRSRTransformation;

public class TransformUtils {
    private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public static final CCModelState DEFAULT_BLOCK;
    public static final CCModelState DEFAULT_ITEM;
    public static final CCModelState DEFAULT_TOOL;
    public static final CCModelState DEFAULT_BOW;

    public static TRSRTransformation get(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(rx, ry, rz)), new Vector3f(s, s, s), null));
    }

    public static TRSRTransformation leftify(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public static TRSRTransformation fromMatrix4(Matrix4 matrix4) {
        TRSRTransformation transformation = new TRSRTransformation(matrix4.toMatrix4f());
        transformation.getLeftRot();
        return transformation;
    }

    static {
        TRSRTransformation thirdPerson = TransformUtils.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        ImmutableMap.Builder defaultBlockBuilder = ImmutableMap.builder();
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)TransformUtils.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)TransformUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.leftify(thirdPerson));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        DEFAULT_BLOCK = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultBlockBuilder.build());
        thirdPerson = TransformUtils.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstPerson = TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        ImmutableMap.Builder defaultItemBuilder = ImmutableMap.builder();
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)TransformUtils.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.leftify(thirdPerson));
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstPerson);
        defaultItemBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.leftify(firstPerson));
        DEFAULT_ITEM = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultItemBuilder.build());
        ImmutableMap.Builder defaultToolBuilder = ImmutableMap.builder();
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)TransformUtils.get(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.get(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        defaultToolBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultToolBuilder.build());
        ImmutableMap.Builder defaultBowBuilder = ImmutableMap.builder();
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)TransformUtils.get(-1.0f, -2.0f, 2.5f, -80.0f, 260.0f, -40.0f, 0.9f));
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.get(-1.0f, -2.0f, 2.5f, -80.0f, -280.0f, 40.0f, 0.9f));
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        defaultBowBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_BOW = new CCModelState((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)defaultBowBuilder.build());
    }
}

