/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.client.UnlistedProperty;
import appeng.client.render.crafting.CraftingCubeState;
import appeng.core.sync.GuiBridge;
import appeng.tile.crafting.TileCraftingTile;
import appeng.util.Platform;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockCraftingUnit
extends AEBaseTileBlock {
    public static final PropertyBool FORMED = PropertyBool.func_177716_a((String)"formed");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final UnlistedProperty<CraftingCubeState> STATE = new UnlistedProperty<CraftingCubeState>("state", CraftingCubeState.class);
    public final CraftingUnitType type;

    public BlockCraftingUnit(CraftingUnitType type) {
        super(Material.field_151573_f);
        this.type = type;
        this.setTileEntity(TileCraftingTile.class);
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{POWERED, FORMED};
    }

    public IExtendedBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumSet<EnumFacing> connections = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.values()) {
            if (!this.isConnected(world, pos, facing)) continue;
            connections.add(facing);
        }
        IExtendedBlockState extState = (IExtendedBlockState)state;
        return extState.withProperty(STATE, (Object)new CraftingCubeState(connections));
    }

    private boolean isConnected(IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockPos adjacentPos = pos.func_177972_a(side);
        return world.func_180495_p(adjacentPos).func_177230_c() instanceof BlockCraftingUnit;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, this.getAEStates(), new IUnlistedProperty[]{STATE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf((meta & 2) == 2));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        boolean p = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean f = (Boolean)state.func_177229_b((IProperty)FORMED);
        return (p ? 1 : 0) | (f ? 2 : 0);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        TileCraftingTile cp = (TileCraftingTile)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (cp != null) {
            cp.updateMultiBlock();
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public void func_180663_b(World w, BlockPos pos, IBlockState state) {
        TileCraftingTile cp = (TileCraftingTile)this.getTileEntity((IBlockAccess)w, pos);
        if (cp != null) {
            cp.breakCluster();
        }
        super.func_180663_b(w, pos, state);
    }

    @Override
    public boolean func_180639_a(World w, BlockPos pos, IBlockState state, EntityPlayer p, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileCraftingTile tg = (TileCraftingTile)this.getTileEntity((IBlockAccess)w, pos);
        if (tg != null && !p.func_70093_af() && tg.isFormed() && tg.isActive()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(p, tg, AEPartLocation.fromFacing(side), GuiBridge.GUI_CRAFTING_CPU);
            return true;
        }
        return false;
    }

    public static enum CraftingUnitType {
        UNIT,
        ACCELERATOR,
        STORAGE_1K,
        STORAGE_4K,
        STORAGE_16K,
        STORAGE_64K,
        MONITOR;

    }
}

