/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.definitions.IItemDefinition;
import appeng.api.util.AEColor;
import appeng.api.util.AEColoredItemDefinition;
import appeng.bootstrap.BlockDefinitionBuilder;
import appeng.bootstrap.IBlockBuilder;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemBuilder;
import appeng.bootstrap.ItemDefinitionBuilder;
import appeng.bootstrap.components.BuiltInModelComponent;
import appeng.bootstrap.components.InitComponent;
import appeng.bootstrap.components.ModelOverrideComponent;
import appeng.bootstrap.components.PostInitComponent;
import appeng.bootstrap.components.PreInitComponent;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.ColoredItemDefinition;
import appeng.core.features.ItemStackSrc;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FeatureFactory {
    private final AEFeature[] defaultFeatures;
    private final List<IBootstrapComponent> bootstrapComponents;
    @SideOnly(value=Side.CLIENT)
    ModelOverrideComponent modelOverrideComponent;
    @SideOnly(value=Side.CLIENT)
    private BuiltInModelComponent builtInModelComponent;

    public FeatureFactory() {
        this.defaultFeatures = new AEFeature[]{AEFeature.Core};
        this.bootstrapComponents = new ArrayList<IBootstrapComponent>();
        if (Platform.isClient()) {
            this.modelOverrideComponent = new ModelOverrideComponent();
            this.bootstrapComponents.add(this.modelOverrideComponent);
            this.builtInModelComponent = new BuiltInModelComponent();
            this.bootstrapComponents.add(this.builtInModelComponent);
        }
    }

    private FeatureFactory(FeatureFactory parent, AEFeature ... defaultFeatures) {
        this.defaultFeatures = (AEFeature[])defaultFeatures.clone();
        this.bootstrapComponents = parent.bootstrapComponents;
        if (Platform.isClient()) {
            this.modelOverrideComponent = parent.modelOverrideComponent;
            this.builtInModelComponent = parent.builtInModelComponent;
        }
    }

    public IBlockBuilder block(String id, Supplier<Block> block) {
        return new BlockDefinitionBuilder(this, id, block).features(this.defaultFeatures);
    }

    public IItemBuilder item(String id, Supplier<Item> item) {
        return new ItemDefinitionBuilder(this, id, item).features(this.defaultFeatures);
    }

    public AEColoredItemDefinition colored(IItemDefinition target, int offset) {
        ColoredItemDefinition definition = new ColoredItemDefinition();
        target.maybeItem().ifPresent(targetItem -> {
            for (AEColor color : AEColor.VALID_COLORS) {
                ActivityState state = ActivityState.from(target.isEnabled());
                definition.add(color, new ItemStackSrc((Item)targetItem, offset + color.ordinal(), state));
            }
        });
        return definition;
    }

    public FeatureFactory features(AEFeature ... features) {
        return new FeatureFactory(this, features);
    }

    void addBootstrapComponent(IBootstrapComponent component) {
        this.bootstrapComponents.add(component);
    }

    void addPreInit(PreInitComponent component) {
        this.bootstrapComponents.add(component);
    }

    void addInit(InitComponent component) {
        this.bootstrapComponents.add(component);
    }

    void addPostInit(PostInitComponent component) {
        this.bootstrapComponents.add(component);
    }

    @SideOnly(value=Side.CLIENT)
    void addBuiltInModel(String path, IModel model) {
        this.builtInModelComponent.addModel(path, model);
    }

    public List<IBootstrapComponent> getBootstrapComponents() {
        return this.bootstrapComponents;
    }
}

