/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.block.networking.BlockCableBus;
import appeng.client.render.cablebus.CableBuilder;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeBuilder;
import appeng.client.render.cablebus.QuadRotator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CableBusBakedModel
implements IBakedModel {
    private final CableBuilder cableBuilder;
    private final FacadeBuilder facadeBuilder;
    private final Map<ResourceLocation, IBakedModel> partModels;
    private final TextureAtlasSprite particleTexture;

    CableBusBakedModel(CableBuilder cableBuilder, FacadeBuilder facadeBuilder, Map<ResourceLocation, IBakedModel> partModels, TextureAtlasSprite particleTexture) {
        this.cableBuilder = cableBuilder;
        this.facadeBuilder = facadeBuilder;
        this.partModels = partModels;
        this.particleTexture = particleTexture;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        CableBusRenderState renderState = CableBusBakedModel.getRenderingState(state);
        if (renderState == null || side != null) {
            return Collections.emptyList();
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (layer == BlockRenderLayer.CUTOUT) {
            this.addCableQuads(renderState, quads);
            for (EnumFacing facing : EnumFacing.values()) {
                List<ResourceLocation> models = renderState.getAttachments().get(facing);
                if (models == null) continue;
                for (ResourceLocation model : models) {
                    IBakedModel bakedModel = this.partModels.get(model);
                    if (bakedModel == null) {
                        throw new IllegalStateException("Trying to use an unregistered part model: " + model);
                    }
                    List<BakedQuad> partQuads = bakedModel.func_188616_a(state, null, rand);
                    QuadRotator rotator = new QuadRotator();
                    partQuads = rotator.rotateQuads(partQuads, facing, EnumFacing.UP);
                    quads.addAll(partQuads);
                }
            }
        }
        this.facadeBuilder.addFacades(layer, renderState.getFacades(), renderState.getBoundingBoxes(), renderState.getAttachments().keySet(), rand, quads);
        return quads;
    }

    private static boolean isStraightLine(AECableType cableType, EnumMap<EnumFacing, AECableType> sides) {
        Iterator<EnumFacing> it = sides.keySet().iterator();
        if (!it.hasNext()) {
            return false;
        }
        EnumFacing firstSide = it.next();
        AECableType firstType = sides.get(firstSide);
        if (!it.hasNext()) {
            return false;
        }
        if (firstSide.func_176734_d() != it.next()) {
            return false;
        }
        if (it.hasNext()) {
            return false;
        }
        AECableType secondType = sides.get(firstSide.func_176734_d());
        switch (cableType) {
            case GLASS: {
                return firstType == AECableType.GLASS && secondType == AECableType.GLASS;
            }
            case DENSE: {
                return firstType == AECableType.DENSE && secondType == AECableType.DENSE;
            }
        }
        return true;
    }

    private void addCableQuads(CableBusRenderState renderState, List<BakedQuad> quadsOut) {
        AECableType cableType = renderState.getCableType();
        if (cableType == AECableType.NONE) {
            return;
        }
        AEColor cableColor = renderState.getCableColor();
        EnumMap<EnumFacing, AECableType> connectionTypes = renderState.getConnectionTypes();
        boolean noAttachments = renderState.getAttachments().isEmpty();
        if (CableBusBakedModel.isStraightLine(cableType, connectionTypes) && noAttachments) {
            EnumFacing facing = connectionTypes.keySet().iterator().next();
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addStraightGlassConnection(facing, cableColor, quadsOut);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addStraightCoveredConnection(facing, cableColor, quadsOut);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addStraightSmartConnection(facing, cableColor, renderState.getChannelsOnSide().get(facing), quadsOut);
                    break;
                }
                case DENSE: {
                    this.cableBuilder.addStraightDenseConnection(facing, cableColor, renderState.getChannelsOnSide().get(facing), quadsOut);
                }
            }
            return;
        }
        this.cableBuilder.addCableCore(renderState.getCoreType(), cableColor, quadsOut);
        EnumMap<EnumFacing, Integer> attachmentConnections = renderState.getAttachmentConnections();
        for (EnumFacing facing : attachmentConnections.keySet()) {
            int distance = attachmentConnections.get(facing);
            int channels = renderState.getChannelsOnSide().get(facing);
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addConstrainedGlassConnection(facing, cableColor, distance, quadsOut);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addConstrainedCoveredConnection(facing, cableColor, distance, quadsOut);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addConstrainedSmartConnection(facing, cableColor, distance, channels, quadsOut);
                    break;
                }
            }
        }
        for (EnumFacing facing : connectionTypes.keySet()) {
            AECableType connectionType = connectionTypes.get(facing);
            boolean cableBusAdjacent = renderState.getCableBusAdjacent().contains(facing);
            int channels = renderState.getChannelsOnSide().get(facing);
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addGlassConnection(facing, cableColor, connectionType, cableBusAdjacent, quadsOut);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, quadsOut);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addSmartConnection(facing, cableColor, connectionType, cableBusAdjacent, channels, quadsOut);
                    break;
                }
                case DENSE: {
                    this.cableBuilder.addDenseConnection(facing, cableColor, connectionType, cableBusAdjacent, channels, quadsOut);
                }
            }
        }
    }

    public List<TextureAtlasSprite> getParticleTextures(CableBusRenderState renderState) {
        CableCoreType coreType = CableCoreType.fromCableType(renderState.getCableType());
        AEColor cableColor = renderState.getCableColor();
        if (coreType != null) {
            return Collections.singletonList(this.cableBuilder.getCoreTexture(coreType, cableColor));
        }
        return Collections.emptyList();
    }

    private static CableBusRenderState getRenderingState(IBlockState state) {
        if (state == null || !(state instanceof IExtendedBlockState)) {
            return null;
        }
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        return (CableBusRenderState)extendedBlockState.getValue(BlockCableBus.RENDER_STATE_PROPERTY);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleTexture;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

