/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.AEApi;
import appeng.api.util.AEAxisAlignedBB;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.core.AELog;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class FacadeBuilder {
    private static final ResourceLocation TEXTURE_FACADE = new ResourceLocation("appliedenergistics2", "parts/cable_anchor");
    private final BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
    private final VertexFormat format;
    private final TextureAtlasSprite facadeTexture;
    private final BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();

    FacadeBuilder(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.format = format;
        this.facadeTexture = (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE_FACADE);
    }

    static Collection<ResourceLocation> getTextures() {
        return Collections.singletonList(TEXTURE_FACADE);
    }

    void addFacades(BlockRenderLayer layer, Map<EnumFacing, FacadeRenderState> facadesState, List<AxisAlignedBB> partBoxes, Set<EnumFacing> sidesWithParts, long rand, List<BakedQuad> quads) {
        boolean thinFacades = FacadeBuilder.isUseThinFacades(partBoxes);
        CubeBuilder builder = new CubeBuilder(this.format, quads);
        facadesState.forEach((side, textureItem) -> {
            AxisAlignedBB facadeBox = FacadeBuilder.getFacadeBox(side, thinFacades);
            AEAxisAlignedBB cutOutBox = FacadeBuilder.getCutOutBox(facadeBox, partBoxes);
            boolean renderStilt = !sidesWithParts.contains(side);
            try {
                this.addFacade(layer, facadesState, (EnumFacing)side, cutOutBox, thinFacades, renderStilt, rand, builder);
            }
            catch (Throwable t) {
                AELog.debug(t);
            }
        });
    }

    public static TextureAtlasSprite getSprite(IBakedModel blockModel, IBlockState state, EnumFacing facing, long rand) {
        Iterator iterator = blockModel.func_188616_a(state, facing, rand).iterator();
        if (iterator.hasNext()) {
            BakedQuad bakedQuad = (BakedQuad)iterator.next();
            return bakedQuad.func_187508_a();
        }
        TextureAtlasSprite firstFound = null;
        for (BakedQuad bakedQuad : blockModel.func_188616_a(state, null, rand)) {
            if (firstFound == null) {
                firstFound = bakedQuad.func_187508_a();
            }
            if (bakedQuad.func_178210_d() != facing) continue;
            return bakedQuad.func_187508_a();
        }
        return firstFound;
    }

    private void addFacade(BlockRenderLayer layer, Map<EnumFacing, FacadeRenderState> facades, EnumFacing side, AEAxisAlignedBB busBounds, boolean thinFacades, boolean renderStilt, long rand, CubeBuilder builder) {
        boolean translucent;
        FacadeRenderState facadeState = facades.get(side);
        IBlockState blockState = facadeState.getSourceBlock();
        builder.setDrawFaces(EnumSet.allOf(EnumFacing.class));
        if (renderStilt && busBounds == null && layer == BlockRenderLayer.CUTOUT) {
            builder.setTexture(this.facadeTexture);
            switch (side) {
                case DOWN: {
                    builder.addCube(7.0f, 1.0f, 7.0f, 9.0f, 6.0f, 9.0f);
                    break;
                }
                case UP: {
                    builder.addCube(7.0f, 10.0f, 7.0f, 9.0f, 15.0f, 9.0f);
                    break;
                }
                case NORTH: {
                    builder.addCube(7.0f, 7.0f, 1.0f, 9.0f, 9.0f, 6.0f);
                    break;
                }
                case SOUTH: {
                    builder.addCube(7.0f, 7.0f, 10.0f, 9.0f, 9.0f, 15.0f);
                    break;
                }
                case WEST: {
                    builder.addCube(1.0f, 7.0f, 7.0f, 6.0f, 9.0f, 9.0f);
                    break;
                }
                case EAST: {
                    builder.addCube(10.0f, 7.0f, 7.0f, 15.0f, 9.0f, 9.0f);
                }
            }
        }
        if ((translucent = AEApi.instance().partHelper().getCableRenderMode().transparentFacades) && layer != BlockRenderLayer.TRANSLUCENT) {
            return;
        }
        float thickness = thinFacades ? 1.0f : 2.0f;
        IBakedModel blockModel = this.blockRendererDispatcher.func_184389_a(blockState);
        int color = 0xFFFFFF;
        try {
            this.blockColors.func_189991_a(blockState);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (translucent) {
            color &= 0xFFFFFF;
            builder.setColor(color |= 0x4C000000);
        } else {
            builder.setColorRGB(color);
        }
        for (EnumFacing facing : facadeState.getOpenFaces()) {
            TextureAtlasSprite sprite = FacadeBuilder.getSprite(blockModel, blockState, facing, rand);
            if (sprite != null) {
                builder.setTexture(facing, sprite);
                continue;
            }
            builder.setTexture(facing, this.facadeTexture);
        }
        builder.setDrawFaces(facadeState.getOpenFaces());
        AxisAlignedBB primaryBox = FacadeBuilder.getFacadeBox(side, thinFacades);
        Vector3f min = new Vector3f((float)primaryBox.field_72340_a * 16.0f, (float)primaryBox.field_72338_b * 16.0f, (float)primaryBox.field_72339_c * 16.0f);
        Vector3f max = new Vector3f((float)primaryBox.field_72336_d * 16.0f, (float)primaryBox.field_72337_e * 16.0f, (float)primaryBox.field_72334_f * 16.0f);
        if (busBounds == null) {
            if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (facades.containsKey(EnumFacing.UP)) {
                    max.y -= thickness;
                }
                if (facades.containsKey(EnumFacing.DOWN)) {
                    min.y += thickness;
                }
            } else if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                if (facades.containsKey(EnumFacing.UP)) {
                    max.y -= thickness;
                }
                if (facades.containsKey(EnumFacing.DOWN)) {
                    min.y += thickness;
                }
                if (facades.containsKey(EnumFacing.SOUTH)) {
                    max.z -= thickness;
                }
                if (facades.containsKey(EnumFacing.NORTH)) {
                    min.z += thickness;
                }
            }
            builder.addCube(min.x, min.y, min.z, max.x, max.y, max.z);
        } else {
            Vector3f busMin = new Vector3f((float)busBounds.minX * 16.0f, (float)busBounds.minY * 16.0f, (float)busBounds.minZ * 16.0f);
            Vector3f busMax = new Vector3f((float)busBounds.maxX * 16.0f, (float)busBounds.maxY * 16.0f, (float)busBounds.maxZ * 16.0f);
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                this.renderSegmentBlockCurrentBounds(builder, min, max, 0.0f, 0.0f, busMax.z, 16.0f, 16.0f, 16.0f);
                this.renderSegmentBlockCurrentBounds(builder, min, max, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, busMin.z);
                this.renderSegmentBlockCurrentBounds(builder, min, max, 0.0f, 0.0f, busMin.z, busMin.x, 16.0f, busMax.z);
                this.renderSegmentBlockCurrentBounds(builder, min, max, busMax.x, 0.0f, busMin.z, 16.0f, 16.0f, busMax.z);
            } else if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                if (facades.get(EnumFacing.UP) != null) {
                    max.y -= thickness;
                }
                if (facades.get(EnumFacing.DOWN) != null) {
                    min.y += thickness;
                }
                this.renderSegmentBlockCurrentBounds(builder, min, max, busMax.x, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
                this.renderSegmentBlockCurrentBounds(builder, min, max, 0.0f, 0.0f, 0.0f, busMin.x, 16.0f, 16.0f);
                this.renderSegmentBlockCurrentBounds(builder, min, max, busMin.x, 0.0f, 0.0f, busMax.x, busMin.y, 16.0f);
                this.renderSegmentBlockCurrentBounds(builder, min, max, busMin.x, busMax.y, 0.0f, busMax.x, 16.0f, 16.0f);
            } else {
                if (facades.get(EnumFacing.UP) != null) {
                    max.y -= thickness;
                }
                if (facades.get(EnumFacing.DOWN) != null) {
                    min.y += thickness;
                }
                if (facades.get(EnumFacing.SOUTH) != null) {
                    max.z -= thickness;
                }
                if (facades.get(EnumFacing.NORTH) != null) {
                    min.z += thickness;
                }
                this.renderSegmentBlockCurrentBounds(builder, min, max, 0.0f, 0.0f, busMax.z, 16.0f, 16.0f, 16.0f);
                this.renderSegmentBlockCurrentBounds(builder, min, max, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, busMin.z);
                this.renderSegmentBlockCurrentBounds(builder, min, max, 0.0f, 0.0f, busMin.z, 16.0f, busMin.y, busMax.z);
                this.renderSegmentBlockCurrentBounds(builder, min, max, 0.0f, busMax.y, busMin.z, 16.0f, 16.0f, busMax.z);
            }
        }
    }

    private void renderSegmentBlockCurrentBounds(CubeBuilder builder, Vector3f min, Vector3f max, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        minX = Math.max(min.x, minX);
        minY = Math.max(min.y, minY);
        minZ = Math.max(min.z, minZ);
        maxX = Math.min(max.x, maxX);
        maxY = Math.min(max.y, maxY);
        maxZ = Math.min(max.z, maxZ);
        if ((double)(maxX - minX) >= 1.0 && (double)(maxY - minY) >= 1.0 && (double)(maxZ - minZ) >= 1.0) {
            builder.addCube(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    @Nullable
    private static AEAxisAlignedBB getCutOutBox(AxisAlignedBB facadeBox, List<AxisAlignedBB> partBoxes) {
        AEAxisAlignedBB b = null;
        for (AxisAlignedBB bb : partBoxes) {
            if (!bb.func_72326_a(facadeBox)) continue;
            if (b == null) {
                b = AEAxisAlignedBB.fromBounds(bb);
                continue;
            }
            b.maxX = Math.max(b.maxX, bb.field_72336_d);
            b.maxY = Math.max(b.maxY, bb.field_72337_e);
            b.maxZ = Math.max(b.maxZ, bb.field_72334_f);
            b.minX = Math.min(b.minX, bb.field_72340_a);
            b.minY = Math.min(b.minY, bb.field_72338_b);
            b.minZ = Math.min(b.minZ, bb.field_72339_c);
        }
        return b;
    }

    private static boolean isUseThinFacades(List<AxisAlignedBB> partBoxes) {
        double min = 0.125;
        double max = 0.875;
        for (AxisAlignedBB bb : partBoxes) {
            int o = 0;
            o += bb.field_72336_d > 0.875 ? 1 : 0;
            o += bb.field_72337_e > 0.875 ? 1 : 0;
            o += bb.field_72334_f > 0.875 ? 1 : 0;
            o += bb.field_72340_a < 0.125 ? 1 : 0;
            o += bb.field_72338_b < 0.125 ? 1 : 0;
            if ((o += bb.field_72339_c < 0.125 ? 1 : 0) < 2) continue;
            return true;
        }
        return false;
    }

    private static AxisAlignedBB getFacadeBox(EnumFacing side, boolean thinFacades) {
        int thickness = thinFacades ? 1 : 2;
        switch (side) {
            case DOWN: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)thickness / 16.0, 1.0);
            }
            case EAST: {
                return new AxisAlignedBB((16.0 - (double)thickness) / 16.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            case NORTH: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)thickness / 16.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.0, 0.0, (16.0 - (double)thickness) / 16.0, 1.0, 1.0, 1.0);
            }
            case UP: {
                return new AxisAlignedBB(0.0, (16.0 - (double)thickness) / 16.0, 0.0, 1.0, 1.0, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, (double)thickness / 16.0, 1.0, 1.0);
            }
        }
        throw new IllegalArgumentException("Unsupported face: " + side);
    }
}

