/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.Upgrades;
import appeng.api.features.IRecipeHandlerRegistry;
import appeng.api.features.IRegistryContainer;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWorldGen;
import appeng.api.movable.IMovableRegistry;
import appeng.api.networking.IGridCacheRegistry;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.capabilities.Capabilities;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.core.RecipeLoader;
import appeng.core.api.ApiPart;
import appeng.core.api.definitions.ApiBlocks;
import appeng.core.api.definitions.ApiItems;
import appeng.core.api.definitions.ApiParts;
import appeng.core.features.AEFeature;
import appeng.core.features.registries.P2PTunnelRegistry;
import appeng.core.features.registries.entries.BasicCellHandler;
import appeng.core.features.registries.entries.CreativeCellHandler;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.stats.PlayerStatsRegistration;
import appeng.hooks.TickHandler;
import appeng.items.materials.ItemMaterial;
import appeng.items.parts.ItemFacade;
import appeng.loot.ChestLoot;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cache.EnergyGridCache;
import appeng.me.cache.GridStorageCache;
import appeng.me.cache.P2PCache;
import appeng.me.cache.PathGridCache;
import appeng.me.cache.SecurityCache;
import appeng.me.cache.SpatialPylonCache;
import appeng.me.cache.TickManagerCache;
import appeng.parts.PartPlacement;
import appeng.recipes.AEItemResolver;
import appeng.recipes.CustomRecipeConfig;
import appeng.recipes.RecipeHandler;
import appeng.recipes.game.DisassembleRecipe;
import appeng.recipes.game.FacadeRecipe;
import appeng.recipes.game.ShapedRecipe;
import appeng.recipes.game.ShapelessRecipe;
import appeng.recipes.handlers.Crusher;
import appeng.recipes.handlers.Grind;
import appeng.recipes.handlers.GrindFZ;
import appeng.recipes.handlers.HCCrusher;
import appeng.recipes.handlers.Inscribe;
import appeng.recipes.handlers.Macerator;
import appeng.recipes.handlers.MekCrusher;
import appeng.recipes.handlers.MekEnrichment;
import appeng.recipes.handlers.Press;
import appeng.recipes.handlers.Pulverizer;
import appeng.recipes.handlers.Shaped;
import appeng.recipes.handlers.Shapeless;
import appeng.recipes.handlers.Smelt;
import appeng.recipes.ores.OreDictionaryHandler;
import appeng.spatial.BiomeGenStorage;
import appeng.spatial.StorageWorldProvider;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import appeng.worldgen.MeteoriteWorldGen;
import appeng.worldgen.QuartzWorldGen;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;

public final class Registration {
    private final RecipeHandler recipeHandler = new RecipeHandler();
    private DimensionType storageDimensionType;
    private Biome storageBiome;

    Registration() {
    }

    public Biome getStorageBiome() {
        return this.storageBiome;
    }

    public DimensionType getStorageDimensionType() {
        return this.storageDimensionType;
    }

    void preInitialize(FMLPreInitializationEvent event) {
        this.registerSpatial(false);
        Capabilities.register();
        Api api = Api.INSTANCE;
        IRecipeHandlerRegistry recipeRegistry = api.registries().recipes();
        this.registerCraftHandlers(recipeRegistry);
        RecipeSorter.register((String)"AE2-Facade", FacadeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"AE2-Shaped", ShapedRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"AE2-Shapeless", ShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        MinecraftForge.EVENT_BUS.register((Object)OreDictionaryHandler.INSTANCE);
        ApiDefinitions definitions = api.definitions();
        definitions.getRegistry().getBootstrapComponents().forEach(b -> b.preInitialize(event.getSide()));
    }

    private void registerSpatial(boolean force) {
        if (!AEConfig.instance.isFeatureEnabled(AEFeature.SpatialIO)) {
            return;
        }
        AEConfig config = AEConfig.instance;
        if (this.storageBiome == null) {
            if (force && config.storageBiomeID == -1) {
                config.storageBiomeID = Platform.findEmpty(Biome.field_185377_q, 0, 256);
                if (config.storageBiomeID == -1) {
                    throw new IllegalStateException("Biome Array is full, please free up some Biome ID's or disable spatial.");
                }
                this.storageBiome = new BiomeGenStorage();
                Biome.func_185354_a((int)config.storageBiomeID, (String)"appliedenergistics2:storage_biome", (Biome)this.storageBiome);
                config.save();
            }
            if (!force && config.storageBiomeID != -1) {
                this.storageBiome = new BiomeGenStorage();
                Biome.func_185354_a((int)config.storageBiomeID, (String)"appliedenergistics2:storage_biome", (Biome)this.storageBiome);
            }
        }
        if (config.storageProviderID != -1) {
            this.storageDimensionType = DimensionType.register((String)"Storage Cell", (String)"_cell", (int)config.storageProviderID, StorageWorldProvider.class, (boolean)false);
        }
        if (config.storageProviderID == -1 && force) {
            HashSet<Integer> ids = new HashSet<Integer>();
            for (DimensionType type : DimensionType.values()) {
                ids.add(type.func_186068_a());
            }
            config.storageProviderID = -11;
            while (ids.contains(config.storageProviderID)) {
                --config.storageProviderID;
            }
            this.storageDimensionType = DimensionType.register((String)"Storage Cell", (String)"_cell", (int)config.storageProviderID, StorageWorldProvider.class, (boolean)false);
            config.save();
        }
    }

    private void registerCraftHandlers(IRecipeHandlerRegistry registry) {
        registry.addNewSubItemResolver(new AEItemResolver());
        registry.addNewCraftHandler("hccrusher", HCCrusher.class);
        registry.addNewCraftHandler("mekcrusher", MekCrusher.class);
        registry.addNewCraftHandler("mekechamber", MekEnrichment.class);
        registry.addNewCraftHandler("grind", Grind.class);
        registry.addNewCraftHandler("crusher", Crusher.class);
        registry.addNewCraftHandler("grindfz", GrindFZ.class);
        registry.addNewCraftHandler("pulverizer", Pulverizer.class);
        registry.addNewCraftHandler("macerator", Macerator.class);
        registry.addNewCraftHandler("smelt", Smelt.class);
        registry.addNewCraftHandler("inscribe", Inscribe.class);
        registry.addNewCraftHandler("press", Press.class);
        registry.addNewCraftHandler("shaped", Shaped.class);
        registry.addNewCraftHandler("shapeless", Shapeless.class);
    }

    public void initialize(@Nonnull FMLInitializationEvent event, @Nonnull File recipeDirectory, @Nonnull CustomRecipeConfig customRecipeConfig) {
        Preconditions.checkNotNull((Object)event);
        Preconditions.checkNotNull((Object)recipeDirectory);
        Preconditions.checkArgument((!recipeDirectory.isFile() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)customRecipeConfig);
        Api api = Api.INSTANCE;
        ApiPart partHelper = api.partHelper();
        IRegistryContainer registries = api.registries();
        ApiDefinitions definitions = api.definitions();
        definitions.getRegistry().getBootstrapComponents().forEach(b -> b.initialize(event.getSide()));
        ItemMaterial.instance.makeUnique();
        RecipeLoader recipeLoader = new RecipeLoader(recipeDirectory, customRecipeConfig, this.recipeHandler);
        recipeLoader.run();
        FMLCommonHandler.instance().bus().register((Object)TickHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TickHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new PartPlacement());
        if (AEConfig.instance.isFeatureEnabled(AEFeature.ChestLoot)) {
            MinecraftForge.EVENT_BUS.register((Object)new ChestLoot());
        }
        IGridCacheRegistry gcr = registries.gridCache();
        gcr.registerGridCache(ITickManager.class, TickManagerCache.class);
        gcr.registerGridCache(IEnergyGrid.class, EnergyGridCache.class);
        gcr.registerGridCache(IPathingGrid.class, PathGridCache.class);
        gcr.registerGridCache(IStorageGrid.class, GridStorageCache.class);
        gcr.registerGridCache(P2PCache.class, P2PCache.class);
        gcr.registerGridCache(ISpatialCache.class, SpatialPylonCache.class);
        gcr.registerGridCache(ISecurityGrid.class, SecurityCache.class);
        gcr.registerGridCache(ICraftingGrid.class, CraftingGridCache.class);
        registries.cell().addCellHandler(new BasicCellHandler());
        registries.cell().addCellHandler(new CreativeCellHandler());
        api.definitions().materials().matterBall().maybeStack(1).ifPresent(ammoStack -> {
            double weight = 32.0;
            registries.matterCannon().registerAmmo((ItemStack)ammoStack, 32.0);
        });
        this.recipeHandler.injectRecipes();
        PlayerStatsRegistration registration = new PlayerStatsRegistration(FMLCommonHandler.instance().bus(), AEConfig.instance);
        registration.registerAchievementHandlers();
        registration.registerAchievements();
        if (AEConfig.instance.isFeatureEnabled(AEFeature.EnableDisassemblyCrafting)) {
            GameRegistry.addRecipe((IRecipe)new DisassembleRecipe());
            RecipeSorter.register((String)"appliedenergistics2:disassemble", DisassembleRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.EnableFacadeCrafting)) {
            definitions.items().facade().maybeItem().ifPresent(facadeItem -> {
                GameRegistry.addRecipe((IRecipe)new FacadeRecipe((ItemFacade)facadeItem));
                RecipeSorter.register((String)"appliedenergistics2:facade", FacadeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
            });
        }
    }

    void postInit(FMLPostInitializationEvent event) {
        this.registerSpatial(true);
        Api api = Api.INSTANCE;
        IRegistryContainer registries = api.registries();
        ApiDefinitions definitions = api.definitions();
        ApiParts parts = definitions.parts();
        ApiBlocks blocks = definitions.blocks();
        ApiItems items = definitions.items();
        ((P2PTunnelRegistry)registries.p2pTunnel()).configure();
        PlayerMessages.values();
        GuiText.values();
        Api.INSTANCE.partHelper().initFMPSupport();
        definitions.getRegistry().getBootstrapComponents().forEach(b -> b.postInitialize(event.getSide()));
        Upgrades.CRAFTING.registerItem(parts.iface(), 1);
        Upgrades.CRAFTING.registerItem(blocks.iface(), 1);
        Upgrades.SPEED.registerItem(blocks.iOPort(), 3);
        Upgrades.REDSTONE.registerItem(blocks.iOPort(), 1);
        Upgrades.FUZZY.registerItem(parts.levelEmitter(), 1);
        Upgrades.CRAFTING.registerItem(parts.levelEmitter(), 1);
        Upgrades.FUZZY.registerItem(parts.importBus(), 1);
        Upgrades.REDSTONE.registerItem(parts.importBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.importBus(), 2);
        Upgrades.SPEED.registerItem(parts.importBus(), 4);
        Upgrades.FUZZY.registerItem(parts.exportBus(), 1);
        Upgrades.REDSTONE.registerItem(parts.exportBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.exportBus(), 2);
        Upgrades.SPEED.registerItem(parts.exportBus(), 4);
        Upgrades.CRAFTING.registerItem(parts.exportBus(), 1);
        Upgrades.FUZZY.registerItem(items.cell1k(), 1);
        Upgrades.INVERTER.registerItem(items.cell1k(), 1);
        Upgrades.FUZZY.registerItem(items.cell4k(), 1);
        Upgrades.INVERTER.registerItem(items.cell4k(), 1);
        Upgrades.FUZZY.registerItem(items.cell16k(), 1);
        Upgrades.INVERTER.registerItem(items.cell16k(), 1);
        Upgrades.FUZZY.registerItem(items.cell64k(), 1);
        Upgrades.INVERTER.registerItem(items.cell64k(), 1);
        Upgrades.FUZZY.registerItem(items.portableCell(), 1);
        Upgrades.INVERTER.registerItem(items.portableCell(), 1);
        Upgrades.FUZZY.registerItem(items.viewCell(), 1);
        Upgrades.INVERTER.registerItem(items.viewCell(), 1);
        Upgrades.FUZZY.registerItem(parts.storageBus(), 1);
        Upgrades.INVERTER.registerItem(parts.storageBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.storageBus(), 5);
        Upgrades.FUZZY.registerItem(parts.formationPlane(), 1);
        Upgrades.INVERTER.registerItem(parts.formationPlane(), 1);
        Upgrades.CAPACITY.registerItem(parts.formationPlane(), 5);
        Upgrades.FUZZY.registerItem(items.massCannon(), 1);
        Upgrades.INVERTER.registerItem(items.massCannon(), 1);
        Upgrades.SPEED.registerItem(items.massCannon(), 4);
        Upgrades.SPEED.registerItem(blocks.molecularAssembler(), 5);
        Upgrades.SPEED.registerItem(blocks.inscriber(), 3);
        items.wirelessTerminal().maybeItem().ifPresent(terminal -> registries.wireless().registerWirelessHandler((IWirelessTermHandler)terminal));
        if (AEConfig.instance.isFeatureEnabled(AEFeature.VillagerTrading)) {
            // empty if block
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.CertusQuartzWorldGen)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new QuartzWorldGen(), (int)0);
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.MeteoriteWorldGen)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new MeteoriteWorldGen(), (int)0);
        }
        IMovableRegistry mr = registries.movable();
        mr.blacklistBlock(Blocks.field_150357_h);
        mr.whiteListTileEntity(TileEntityBeacon.class);
        mr.whiteListTileEntity(TileEntityBrewingStand.class);
        mr.whiteListTileEntity(TileEntityChest.class);
        mr.whiteListTileEntity(TileEntityCommandBlock.class);
        mr.whiteListTileEntity(TileEntityComparator.class);
        mr.whiteListTileEntity(TileEntityDaylightDetector.class);
        mr.whiteListTileEntity(TileEntityDispenser.class);
        mr.whiteListTileEntity(TileEntityDropper.class);
        mr.whiteListTileEntity(TileEntityEnchantmentTable.class);
        mr.whiteListTileEntity(TileEntityEnderChest.class);
        mr.whiteListTileEntity(TileEntityEndPortal.class);
        mr.whiteListTileEntity(TileEntitySkull.class);
        mr.whiteListTileEntity(TileEntityFurnace.class);
        mr.whiteListTileEntity(TileEntityMobSpawner.class);
        mr.whiteListTileEntity(TileEntitySign.class);
        mr.whiteListTileEntity(TileEntityPiston.class);
        mr.whiteListTileEntity(TileEntityFlowerPot.class);
        mr.whiteListTileEntity(TileEntityNote.class);
        mr.whiteListTileEntity(TileEntityHopper.class);
        mr.whiteListTileEntity(AEBaseTile.class);
        for (IWorldGen.WorldGenType type : IWorldGen.WorldGenType.values()) {
            registries.worldgen().disableWorldGenForProviderID(type, StorageWorldProvider.class);
            registries.worldgen().disableWorldGenForDimension(type, -1);
            registries.worldgen().disableWorldGenForDimension(type, 1);
        }
        for (int dimension : AEConfig.instance.meteoriteDimensionWhitelist) {
            registries.worldgen().enableWorldGenForDimension(IWorldGen.WorldGenType.METEORITES, dimension);
        }
        OreDictionaryHandler.INSTANCE.bakeRecipes();
    }
}

