/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.entries;

import appeng.api.features.IInscriberRecipe;
import appeng.api.features.InscriberProcessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class InscriberRecipe
implements IInscriberRecipe {
    @Nonnull
    private final List<ItemStack> inputs;
    @Nonnull
    private final ItemStack output;
    @Nonnull
    private final Optional<ItemStack> maybeTop;
    @Nonnull
    private final Optional<ItemStack> maybeBot;
    @Nonnull
    private final InscriberProcessType type;

    public InscriberRecipe(@Nonnull Collection<ItemStack> inputs, @Nonnull ItemStack output, @Nullable ItemStack top, @Nullable ItemStack bot, @Nonnull InscriberProcessType type) {
        this.inputs = new ArrayList<ItemStack>(inputs.size());
        this.inputs.addAll(inputs);
        this.output = output;
        this.maybeTop = Optional.ofNullable(top);
        this.maybeBot = Optional.ofNullable(bot);
        this.type = type;
    }

    @Override
    @Nonnull
    public final List<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    @Nonnull
    public final ItemStack getOutput() {
        return this.output;
    }

    @Override
    @Nonnull
    public final Optional<ItemStack> getTopOptional() {
        return this.maybeTop;
    }

    @Override
    @Nonnull
    public final Optional<ItemStack> getBottomOptional() {
        return this.maybeBot;
    }

    @Override
    @Nonnull
    public final InscriberProcessType getProcessType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IInscriberRecipe)) {
            return false;
        }
        IInscriberRecipe that = (IInscriberRecipe)o;
        if (!this.inputs.equals(that.getInputs())) {
            return false;
        }
        if (!this.output.equals(that.getOutput())) {
            return false;
        }
        if (!this.maybeTop.equals(that.getTopOptional())) {
            return false;
        }
        if (!this.maybeBot.equals(that.getBottomOptional())) {
            return false;
        }
        return this.type == that.getProcessType();
    }

    public int hashCode() {
        int result = this.inputs.hashCode();
        result = 31 * result + this.output.hashCode();
        result = 31 * result + this.maybeTop.hashCode();
        result = 31 * result + this.maybeBot.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

