/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.network;

import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.AppEngClientPacketHandler;
import appeng.core.sync.network.AppEngServerPacketHandler;
import appeng.core.sync.network.IPacketHandler;
import appeng.core.worlddata.WorldData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class NetworkHandler {
    public static NetworkHandler instance;
    private final FMLEventChannel ec;
    private final String myChannelName;
    private final IPacketHandler clientHandler;
    private final IPacketHandler serveHandler;

    public NetworkHandler(String channelName) {
        FMLCommonHandler.instance().bus().register((Object)this);
        this.myChannelName = channelName;
        this.ec = NetworkRegistry.INSTANCE.newEventDrivenChannel(this.myChannelName);
        this.ec.register((Object)this);
        this.clientHandler = this.createClientSide();
        this.serveHandler = this.createServerSide();
    }

    private IPacketHandler createClientSide() {
        try {
            return new AppEngClientPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private IPacketHandler createServerSide() {
        try {
            return new AppEngServerPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void newConnection(FMLNetworkEvent.ServerConnectionFromClientEvent ev) {
        WorldData.instance().dimensionData().sendToPlayer(ev.getManager());
    }

    @SubscribeEvent
    public void newConnection(PlayerEvent.PlayerLoggedInEvent loginEvent) {
        if (loginEvent.player instanceof EntityPlayerMP) {
            WorldData.instance().dimensionData().sendToPlayer(null);
        }
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent ev) {
        NetHandlerPlayServer srv = (NetHandlerPlayServer)ev.getPacket().handler();
        if (this.serveHandler != null) {
            try {
                this.serveHandler.onPacketData(null, ev.getHandler(), ev.getPacket(), (EntityPlayer)srv.field_147369_b);
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent ev) {
        if (this.clientHandler != null) {
            try {
                this.clientHandler.onPacketData(null, ev.getHandler(), ev.getPacket(), null);
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
        }
    }

    public String getChannel() {
        return this.myChannelName;
    }

    public void sendToAll(AppEngPacket message) {
        this.ec.sendToAll(message.getProxy());
    }

    public void sendTo(AppEngPacket message, EntityPlayerMP player) {
        this.ec.sendTo(message.getProxy(), player);
    }

    public void sendToAllAround(AppEngPacket message, NetworkRegistry.TargetPoint point) {
        this.ec.sendToAllAround(message.getProxy(), point);
    }

    public void sendToDimension(AppEngPacket message, int dimensionId) {
        this.ec.sendToDimension(message.getProxy(), dimensionId);
    }

    public void sendToServer(AppEngPacket message) {
        this.ec.sendToServer(message.getProxy());
    }
}

