/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.core.CommonHelper;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileCubeGenerator
extends AEBaseTile
implements ITickable {
    private int size = 3;
    private ItemStack is = null;
    private int countdown = 200;
    private EntityPlayer who = null;

    @TileEvent(value=TileEventType.TICK)
    public void onTickEvent() {
        if (this.is != null && Platform.isServer()) {
            --this.countdown;
            if (this.countdown % 20 == 0) {
                for (EntityPlayer e : CommonHelper.proxy.getPlayers()) {
                    e.func_145747_a((ITextComponent)new TextComponentString("Spawning in... " + this.countdown / 20));
                }
            }
            if (this.countdown <= 0) {
                this.spawn();
            }
        }
    }

    private void spawn() {
        this.field_145850_b.func_175698_g(this.field_174879_c);
        Item i = this.is.func_77973_b();
        EnumFacing side = EnumFacing.UP;
        int half = (int)Math.floor(this.size / 2);
        for (int y = 0; y < this.size; ++y) {
            for (int x = -half; x < half; ++x) {
                for (int z = -half; z < half; ++z) {
                    BlockPos p = this.field_174879_c.func_177982_a(x, y - 1, z);
                    i.func_180614_a(this.is.func_77946_l(), this.who, this.field_145850_b, p, EnumHand.MAIN_HAND, side, 0.5f, 0.0f, 0.5f);
                }
            }
        }
    }

    void click(EntityPlayer player) {
        if (Platform.isServer()) {
            ItemStack hand = player.field_71071_by.func_70448_g();
            this.who = player;
            if (hand == null) {
                this.is = null;
                this.size = player.func_70093_af() ? --this.size : ++this.size;
                if (this.size < 3) {
                    this.size = 3;
                }
                if (this.size > 64) {
                    this.size = 64;
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Size: " + this.size));
            } else {
                this.countdown = 200;
                this.is = hand;
            }
        }
    }
}

