/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.AEApi;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.util.AEPartLocation;
import appeng.facade.IFacadeItem;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class FacadePart
implements IFacadePart,
IBoxProvider {
    private final ItemStack facade;
    private final AEPartLocation side;

    public FacadePart(ItemStack facade, AEPartLocation side) {
        if (facade == null) {
            throw new IllegalArgumentException("Facade Part constructed on null item.");
        }
        this.facade = facade.func_77946_l();
        this.facade.field_77994_a = 1;
        this.side = side;
    }

    public static boolean isFacade(ItemStack is) {
        return is.func_77973_b() instanceof IFacadeItem;
    }

    @Override
    public ItemStack getItemStack() {
        return this.facade;
    }

    @Override
    public void getBoxes(IPartCollisionHelper ch, Entity e) {
        if (e instanceof EntityLivingBase) {
            ch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 16.0);
        } else {
            ch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 15.9);
        }
    }

    @Override
    public AEPartLocation getSide() {
        return this.side;
    }

    @Override
    public Item getItem() {
        ItemStack is = this.getTextureItem();
        if (is == null) {
            return null;
        }
        return is.func_77973_b();
    }

    @Override
    public int getItemDamage() {
        ItemStack is = this.getTextureItem();
        if (is == null) {
            return 0;
        }
        return is.func_77952_i();
    }

    @Override
    public boolean notAEFacade() {
        return !(this.facade.func_77973_b() instanceof IFacadeItem);
    }

    @Override
    public boolean isTransparent() {
        if (AEApi.instance().partHelper().getCableRenderMode().transparentFacades) {
            return true;
        }
        ItemStack is = this.getTextureItem();
        Block blk = Block.func_149634_a((Item)is.func_77973_b());
        return !blk.func_149662_c(blk.func_176223_P());
    }

    @Override
    @Nullable
    public ItemStack getTextureItem() {
        Item maybeFacade = this.facade.func_77973_b();
        if (maybeFacade instanceof IFacadeItem) {
            IFacadeItem facade = (IFacadeItem)maybeFacade;
            return facade.getTextureItem(this.facade);
        }
        return null;
    }

    @Override
    public IBlockState getBlockState() {
        ItemStack itemStack = this.getTextureItem();
        if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        ItemBlock itemBlock = (ItemBlock)itemStack.func_77973_b();
        try {
            return itemBlock.func_179223_d().func_176203_a(itemStack.func_77952_i());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.getBoxes(bch, null);
    }
}

