/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.AEApi;
import appeng.api.networking.IGridNode;
import appeng.api.parts.CableRenderMode;
import appeng.api.util.AEColor;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.sync.packets.PacketPaintedEntity;
import appeng.crafting.CraftingJob;
import appeng.me.Grid;
import appeng.me.NetworkList;
import appeng.tile.AEBaseTile;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickHandler {
    public static final TickHandler INSTANCE = new TickHandler();
    private final Queue<IWorldCallable<?>> serverQueue = new LinkedList();
    private final Multimap<World, CraftingJob> craftingJobs = LinkedListMultimap.create();
    private final WeakHashMap<World, Queue<IWorldCallable<?>>> callQueue = new WeakHashMap();
    private final HandlerRep server = new HandlerRep();
    private final HandlerRep client = new HandlerRep();
    private final HashMap<Integer, PlayerColor> cliPlayerColors = new HashMap();
    private final HashMap<Integer, PlayerColor> srvPlayerColors = new HashMap();
    private CableRenderMode crm = CableRenderMode.STANDARD;

    public HashMap<Integer, PlayerColor> getPlayerColors() {
        if (Platform.isServer()) {
            return this.srvPlayerColors;
        }
        return this.cliPlayerColors;
    }

    public void addCallable(World w, IWorldCallable<?> c) {
        if (w == null) {
            this.serverQueue.add(c);
        } else {
            Queue<IWorldCallable<?>> queue = this.callQueue.get(w);
            if (queue == null) {
                queue = new LinkedList();
                this.callQueue.put(w, queue);
            }
            queue.add(c);
        }
    }

    public void addInit(AEBaseTile tile) {
        if (Platform.isServer()) {
            this.getRepo().tiles.add(tile);
        }
    }

    private HandlerRep getRepo() {
        if (Platform.isServer()) {
            return this.server;
        }
        return this.client;
    }

    public void addNetwork(Grid grid) {
        if (Platform.isServer()) {
            this.getRepo().networks.add(grid);
        }
    }

    public void removeNetwork(Grid grid) {
        if (Platform.isServer()) {
            this.getRepo().networks.remove(grid);
        }
    }

    public Iterable<Grid> getGridList() {
        return this.getRepo().networks;
    }

    public void shutdown() {
        this.getRepo().clear();
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload ev) {
        if (Platform.isServer()) {
            LinkedList<IGridNode> toDestroy = new LinkedList<IGridNode>();
            for (Grid g : this.getRepo().networks) {
                for (IGridNode n : g.getNodes()) {
                    if (n.getWorld() != ev.getWorld()) continue;
                    toDestroy.add(n);
                }
            }
            for (IGridNode n : toDestroy) {
                n.destroy();
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load load) {
        for (Object te : load.getChunk().func_177434_r().values()) {
            if (!(te instanceof AEBaseTile)) continue;
            ((AEBaseTile)te).onChunkLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTick(TickEvent ev) {
        if (ev.type == TickEvent.Type.CLIENT && ev.phase == TickEvent.Phase.START) {
            this.tickColors(this.cliPlayerColors);
            CableRenderMode currentMode = AEApi.instance().partHelper().getCableRenderMode();
            if (currentMode != this.crm) {
                this.crm = currentMode;
                CommonHelper.proxy.triggerUpdates();
            }
        }
        if (ev.type == TickEvent.Type.WORLD && ev.phase == TickEvent.Phase.END) {
            TickEvent.WorldTickEvent wte = (TickEvent.WorldTickEvent)ev;
            Multimap<World, CraftingJob> multimap = this.craftingJobs;
            synchronized (multimap) {
                Collection jobSet = this.craftingJobs.get((Object)wte.world);
                if (!jobSet.isEmpty()) {
                    int simTime = Math.max(1, AEConfig.instance.craftingCalculationTimePerTick / jobSet.size());
                    Iterator i = jobSet.iterator();
                    while (i.hasNext()) {
                        CraftingJob cj = (CraftingJob)i.next();
                        if (cj.simulateFor(simTime)) continue;
                        i.remove();
                    }
                }
            }
        } else if (ev.type == TickEvent.Type.SERVER && ev.phase == TickEvent.Phase.END) {
            this.tickColors(this.srvPlayerColors);
            HandlerRep repo = this.getRepo();
            while (!repo.tiles.isEmpty()) {
                AEBaseTile bt = (AEBaseTile)repo.tiles.poll();
                if (bt.func_145837_r()) continue;
                bt.onReady();
            }
            for (Grid g : this.getRepo().networks) {
                g.update();
            }
            this.processQueue(this.serverQueue, null);
        }
        if (ev.type == TickEvent.Type.WORLD && ev.phase == TickEvent.Phase.START) {
            World world = ((TickEvent.WorldTickEvent)ev).world;
            Queue<IWorldCallable<?>> queue = this.callQueue.get(world);
            this.processQueue(queue, world);
        }
    }

    private void tickColors(HashMap<Integer, PlayerColor> playerSet) {
        Iterator<PlayerColor> i = playerSet.values().iterator();
        while (i.hasNext()) {
            PlayerColor pc = i.next();
            if (pc.ticksLeft <= 0) {
                i.remove();
            }
            pc.ticksLeft--;
        }
    }

    private void processQueue(Queue<IWorldCallable<?>> queue, World world) {
        if (queue == null) {
            return;
        }
        Stopwatch sw = Stopwatch.createStarted();
        IWorldCallable<?> c = null;
        while ((c = queue.poll()) != null) {
            try {
                c.call(world);
                if (sw.elapsed(TimeUnit.MILLISECONDS) <= 50L) continue;
                break;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCraftingSimulation(World world, CraftingJob craftingJob) {
        Multimap<World, CraftingJob> multimap = this.craftingJobs;
        synchronized (multimap) {
            this.craftingJobs.put((Object)world, (Object)craftingJob);
        }
    }

    public static class PlayerColor {
        public final AEColor myColor;
        private final int myEntity;
        private int ticksLeft;

        public PlayerColor(int id, AEColor col, int ticks) {
            this.myEntity = id;
            this.myColor = col;
            this.ticksLeft = ticks;
        }

        public PacketPaintedEntity getPacket() {
            return new PacketPaintedEntity(this.myEntity, this.myColor, this.ticksLeft);
        }
    }

    private static class HandlerRep {
        private Queue<AEBaseTile> tiles = new LinkedList<AEBaseTile>();
        private Collection<Grid> networks = new NetworkList();

        private HandlerRep() {
        }

        private void clear() {
            this.tiles = new LinkedList<AEBaseTile>();
            this.networks = new NetworkList();
        }
    }
}

