/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import appeng.core.AEConfig;
import appeng.recipes.game.ShapedRecipe;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import scala.actors.threadpool.Arrays;

class ShapedRecipeWrapper
extends BlankRecipeWrapper
implements IShapedCraftingRecipeWrapper {
    private final ShapedRecipe recipe;

    public ShapedRecipeWrapper(ShapedRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        boolean useSingleItems = AEConfig.instance.disableColoredCableRecipesInJEI();
        Object[] items = this.recipe.getIngredients();
        int width = this.recipe.getWidth();
        int height = this.recipe.getHeight();
        ArrayList in = new ArrayList(width * height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (items[x * height + y] != null) {
                    IIngredient ing = (IIngredient)items[x * height + y];
                    List slotList = Collections.emptyList();
                    try {
                        Object[] is = ing.getItemStackSet();
                        slotList = useSingleItems ? Platform.findPreferred((ItemStack[])is) : Arrays.asList((Object[])is);
                    }
                    catch (MissingIngredientError | RegistrationError exception) {
                        // empty catch block
                    }
                    in.add(slotList);
                    continue;
                }
                in.add(Collections.emptyList());
            }
        }
        ingredients.setInputLists(ItemStack.class, in);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.func_77571_b());
    }

    public int getWidth() {
        return this.recipe.getWidth();
    }

    public int getHeight() {
        return this.recipe.getHeight();
    }
}

