/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila;

import appeng.api.parts.IPart;
import appeng.integration.modules.waila.part.ChannelWailaDataProvider;
import appeng.integration.modules.waila.part.IPartWailaDataProvider;
import appeng.integration.modules.waila.part.PartAccessor;
import appeng.integration.modules.waila.part.PartStackWailaDataProvider;
import appeng.integration.modules.waila.part.PowerStateWailaDataProvider;
import appeng.integration.modules.waila.part.StorageMonitorWailaDataProvider;
import appeng.integration.modules.waila.part.Tracer;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public final class PartWailaDataProvider
implements IWailaDataProvider {
    private final List<IPartWailaDataProvider> providers;
    private final PartAccessor accessor = new PartAccessor();
    private final Tracer tracer = new Tracer();

    public PartWailaDataProvider() {
        ChannelWailaDataProvider channel = new ChannelWailaDataProvider();
        StorageMonitorWailaDataProvider storageMonitor = new StorageMonitorWailaDataProvider();
        PowerStateWailaDataProvider powerState = new PowerStateWailaDataProvider();
        PartStackWailaDataProvider partStack = new PartStackWailaDataProvider();
        this.providers = Lists.newArrayList((Object[])new IPartWailaDataProvider[]{channel, storageMonitor, powerState, partStack});
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        RayTraceResult mop;
        TileEntity te = accessor.getTileEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getMOP());
        if (maybePart.isPresent()) {
            IPart part = maybePart.get();
            ItemStack wailaStack = null;
            for (IPartWailaDataProvider provider : this.providers) {
                wailaStack = provider.getWailaStack(part, config, wailaStack);
            }
            return wailaStack;
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        RayTraceResult mop;
        TileEntity te = accessor.getTileEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getMOP());
        if (maybePart.isPresent()) {
            IPart part = maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaHead(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        RayTraceResult mop;
        TileEntity te = accessor.getTileEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getMOP());
        if (maybePart.isPresent()) {
            IPart part = maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaBody(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        RayTraceResult mop;
        TileEntity te = accessor.getTileEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getMOP());
        if (maybePart.isPresent()) {
            IPart part = maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getWailaTail(part, currentToolTip, accessor, config);
            }
        }
        return currentToolTip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        Optional<IPart> maybePart;
        RayTraceResult mop = this.tracer.retraceBlock(world, player, pos);
        if (mop != null && (maybePart = this.accessor.getMaybePart(te, mop)).isPresent()) {
            IPart part = maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.getNBTData(player, part, te, tag, world, pos);
            }
        }
        return tag;
    }
}

