/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.parts.IAlphaPassItem;
import appeng.api.util.AEPartLocation;
import appeng.core.AELog;
import appeng.core.FacadeConfig;
import appeng.decorative.solid.BlockQuartzOre;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.AEBaseItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemFacade
extends AEBaseItem
implements IFacadeItem,
IAlphaPassItem {
    private List<ItemStack> subTypes = null;

    public ItemFacade() {
        this.func_77627_a(true);
    }

    public EnumActionResult onItemUseFirst(ItemStack is, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return AEApi.instance().partHelper().placeBus(is, pos, side, player, hand, world);
    }

    public String func_77653_i(ItemStack is) {
        try {
            ItemStack in = this.getTextureItem(is);
            if (in != null) {
                return super.func_77653_i(is) + " - " + in.func_82833_r();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.func_77653_i(is);
    }

    @Override
    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, List<ItemStack> itemStacks) {
        this.calculateSubTypes();
        itemStacks.addAll(this.subTypes);
    }

    private void calculateSubTypes() {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList<ItemStack>(1000);
            for (Object blk : Block.field_149771_c) {
                Block b = (Block)blk;
                try {
                    Item item = Item.func_150898_a((Block)b);
                    ArrayList tmpList = new ArrayList(100);
                    b.func_149666_a(item, b.func_149708_J(), tmpList);
                    for (ItemStack l : tmpList) {
                        ItemStack facade = this.createFacadeForItem(l, false);
                        if (facade == null) continue;
                        this.subTypes.add(facade);
                    }
                }
                catch (Throwable throwable) {
                }
            }
            if (FacadeConfig.instance.hasChanged()) {
                FacadeConfig.instance.save();
            }
        }
    }

    private static boolean hasSimpleModel(IBlockState blockState) {
        if (blockState.func_185901_i() != EnumBlockRenderType.MODEL || blockState instanceof IExtendedBlockState) {
            return false;
        }
        return blockState.func_185917_h();
    }

    public ItemStack createFacadeForItem(ItemStack l, boolean returnItem) {
        boolean defaultValue;
        IBlockState blockState;
        if (l == null) {
            return null;
        }
        Block b = Block.func_149634_a((Item)l.func_77973_b());
        if (b == null || l.func_77942_o()) {
            return null;
        }
        int metadata = l.func_77973_b().func_77647_b(l.func_77952_i());
        boolean hasTile = b.hasTileEntity(b.func_176223_P());
        boolean enableGlass = b instanceof BlockGlass || b instanceof BlockStainedGlass;
        boolean disableOre = b instanceof BlockQuartzOre;
        try {
            blockState = b.func_176203_a(metadata);
        }
        catch (Exception e) {
            AELog.debug(e, "Cannot create a facade for " + b.getRegistryName());
            return null;
        }
        boolean bl = defaultValue = b.func_185481_k(blockState) && ItemFacade.hasSimpleModel(blockState) && !b.func_149653_t() && !hasTile && !disableOre || enableGlass;
        if (FacadeConfig.instance.checkEnabled(b, metadata, defaultValue)) {
            if (returnItem) {
                return l;
            }
            ItemStack is = new ItemStack((Item)this);
            NBTTagCompound data = new NBTTagCompound();
            int[] ds = new int[]{Item.func_150891_b((Item)l.func_77973_b()), metadata};
            data.func_74783_a("x", ds);
            ResourceLocation ui = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)l.func_77973_b());
            data.func_74778_a("modid", ui.func_110624_b());
            data.func_74778_a("itemname", ui.func_110623_a());
            is.func_77982_d(data);
            return is;
        }
        return null;
    }

    @Override
    public FacadePart createPartFromItemStack(ItemStack is, AEPartLocation side) {
        ItemStack in = this.getTextureItem(is);
        if (in != null) {
            return new FacadePart(is, side);
        }
        return null;
    }

    @Override
    public ItemStack getTextureItem(ItemStack is) {
        Block blk = this.getBlock(is);
        if (blk != null) {
            return new ItemStack(blk, 1, this.getMeta(is));
        }
        return null;
    }

    @Override
    public int getMeta(ItemStack is) {
        int[] blk;
        NBTTagCompound data = is.func_77978_p();
        if (data != null && (blk = data.func_74759_k("x")) != null && blk.length == 2) {
            return blk[1];
        }
        return 0;
    }

    @Override
    public Block getBlock(ItemStack is) {
        NBTTagCompound data = is.func_77978_p();
        if (data != null) {
            if (data.func_74764_b("modid") && data.func_74764_b("itemname")) {
                if (data.func_74779_i("modid").equals("minecraft")) {
                    return Block.func_149684_b((String)data.func_74779_i("itemname"));
                }
                return GameRegistry.findBlock((String)data.func_74779_i("modid"), (String)data.func_74779_i("itemname"));
            }
            int[] blk = data.func_74759_k("x");
            if (blk != null && blk.length == 2) {
                return Block.func_149729_e((int)blk[0]);
            }
        }
        return Blocks.field_150359_w;
    }

    public List<ItemStack> getFacades() {
        this.calculateSubTypes();
        return this.subTypes;
    }

    public ItemStack getCreativeTabIcon() {
        this.calculateSubTypes();
        if (this.subTypes.isEmpty()) {
            return new ItemStack(Items.field_151105_aU);
        }
        return this.subTypes.get(0);
    }

    public ItemStack createFromIDs(int[] ids) {
        ItemStack facadeStack = AEApi.instance().definitions().items().facade().maybeStack(1).orElseThrow(() -> new MissingDefinition("Tried to create a facade, while facades are being deactivated."));
        NBTTagCompound facadeTag = new NBTTagCompound();
        facadeTag.func_74783_a("x", (int[])ids.clone());
        facadeStack.func_77982_d(facadeTag);
        return facadeStack;
    }

    @Override
    public boolean useAlphaPass(ItemStack is) {
        ItemStack out = this.getTextureItem(is);
        if (out == null || out.func_77973_b() == null) {
            return false;
        }
        Block blk = Block.func_149634_a((Item)out.func_77973_b());
        return blk != null && blk.canRenderInLayer(BlockRenderLayer.TRANSLUCENT);
    }
}

