/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.parts.IPart;
import appeng.api.util.AEColor;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.integration.IntegrationType;
import appeng.items.parts.PartModelsHelper;
import appeng.parts.automation.PartAnnihilationPlane;
import appeng.parts.automation.PartExportBus;
import appeng.parts.automation.PartFormationPlane;
import appeng.parts.automation.PartIdentityAnnihilationPlane;
import appeng.parts.automation.PartImportBus;
import appeng.parts.automation.PartLevelEmitter;
import appeng.parts.misc.PartCableAnchor;
import appeng.parts.misc.PartInterface;
import appeng.parts.misc.PartInvertedToggleBus;
import appeng.parts.misc.PartStorageBus;
import appeng.parts.misc.PartToggleBus;
import appeng.parts.networking.PartCableCovered;
import appeng.parts.networking.PartCableGlass;
import appeng.parts.networking.PartCableSmart;
import appeng.parts.networking.PartDenseCable;
import appeng.parts.networking.PartQuartzFiber;
import appeng.parts.p2p.PartP2PItems;
import appeng.parts.p2p.PartP2PLight;
import appeng.parts.p2p.PartP2PLiquids;
import appeng.parts.p2p.PartP2PRedstone;
import appeng.parts.p2p.PartP2PTunnelME;
import appeng.parts.reporting.PartConversionMonitor;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartDarkPanel;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.parts.reporting.PartPanel;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartSemiDarkPanel;
import appeng.parts.reporting.PartStorageMonitor;
import appeng.parts.reporting.PartTerminal;
import appeng.util.Platform;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum PartType {
    InvalidType(-1, "invalid", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), null),
    CableGlass(0, "cable_glass", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartCableGlass.class){

        @Override
        public boolean isCable() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected List<ModelResourceLocation> createItemModels(String baseName) {
            return Arrays.stream(AEColor.values()).map(color -> PartType.modelFromBaseName(baseName + "_" + color.name().toLowerCase())).collect(Collectors.toList());
        }
    }
    ,
    CableCovered(20, "cable_covered", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartCableCovered.class){

        @Override
        public boolean isCable() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected List<ModelResourceLocation> createItemModels(String baseName) {
            return Arrays.stream(AEColor.values()).map(color -> PartType.modelFromBaseName(baseName + "_" + color.name().toLowerCase())).collect(Collectors.toList());
        }
    }
    ,
    CableSmart(40, "cable_smart", EnumSet.of(AEFeature.Channels), EnumSet.noneOf(IntegrationType.class), PartCableSmart.class){

        @Override
        public boolean isCable() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected List<ModelResourceLocation> createItemModels(String baseName) {
            return Arrays.stream(AEColor.values()).map(color -> PartType.modelFromBaseName(baseName + "_" + color.name().toLowerCase())).collect(Collectors.toList());
        }
    }
    ,
    CableDense(60, "cable_dense", EnumSet.of(AEFeature.Channels), EnumSet.noneOf(IntegrationType.class), PartDenseCable.class){

        @Override
        public boolean isCable() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected List<ModelResourceLocation> createItemModels(String baseName) {
            return Arrays.stream(AEColor.values()).map(color -> PartType.modelFromBaseName(baseName + "_" + color.name().toLowerCase())).collect(Collectors.toList());
        }
    }
    ,
    ToggleBus(80, "toggle_bus", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartToggleBus.class),
    InvertedToggleBus(100, "inverted_toggle_bus", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartInvertedToggleBus.class),
    CableAnchor(120, "cable_anchor", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartCableAnchor.class),
    QuartzFiber(140, "quartz_fiber", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartQuartzFiber.class),
    Monitor(160, "monitor", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartPanel.class),
    SemiDarkMonitor(180, "semi_dark_monitor", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartSemiDarkPanel.class),
    DarkMonitor(200, "dark_monitor", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartDarkPanel.class),
    StorageBus(220, "storage_bus", EnumSet.of(AEFeature.StorageBus), EnumSet.noneOf(IntegrationType.class), PartStorageBus.class),
    ImportBus(240, "import_bus", EnumSet.of(AEFeature.ImportBus), EnumSet.noneOf(IntegrationType.class), PartImportBus.class),
    ExportBus(260, "export_bus", EnumSet.of(AEFeature.ExportBus), EnumSet.noneOf(IntegrationType.class), PartExportBus.class),
    LevelEmitter(280, "level_emitter", EnumSet.of(AEFeature.LevelEmitter), EnumSet.noneOf(IntegrationType.class), PartLevelEmitter.class),
    AnnihilationPlane(300, "annihilation_plane", EnumSet.of(AEFeature.AnnihilationPlane), EnumSet.noneOf(IntegrationType.class), PartAnnihilationPlane.class),
    IdentityAnnihilationPlane(301, "identity_annihilation_plane", EnumSet.of(AEFeature.AnnihilationPlane, AEFeature.IdentityAnnihilationPlane), EnumSet.noneOf(IntegrationType.class), PartIdentityAnnihilationPlane.class),
    FormationPlane(320, "formation_plane", EnumSet.of(AEFeature.FormationPlane), EnumSet.noneOf(IntegrationType.class), PartFormationPlane.class),
    PatternTerminal(340, "pattern_terminal", EnumSet.of(AEFeature.Patterns), EnumSet.noneOf(IntegrationType.class), PartPatternTerminal.class),
    CraftingTerminal(360, "crafting_terminal", EnumSet.of(AEFeature.CraftingTerminal), EnumSet.noneOf(IntegrationType.class), PartCraftingTerminal.class),
    Terminal(380, "terminal", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartTerminal.class),
    StorageMonitor(400, "storage_monitor", EnumSet.of(AEFeature.StorageMonitor), EnumSet.noneOf(IntegrationType.class), PartStorageMonitor.class),
    ConversionMonitor(420, "conversion_monitor", EnumSet.of(AEFeature.PartConversionMonitor), EnumSet.noneOf(IntegrationType.class), PartConversionMonitor.class),
    Interface(440, "interface", EnumSet.of(AEFeature.Core), EnumSet.noneOf(IntegrationType.class), PartInterface.class),
    P2PTunnelME(460, "p2p_tunnel_me", (Set)EnumSet.of(AEFeature.P2PTunnel, AEFeature.P2PTunnelME), (Set)EnumSet.noneOf(IntegrationType.class), (Class)PartP2PTunnelME.class, GuiText.METunnel){

        @Override
        String getUnlocalizedName() {
            return "P2PTunnel";
        }
    }
    ,
    P2PTunnelRedstone(461, "p2p_tunnel_redstone", (Set)EnumSet.of(AEFeature.P2PTunnel, AEFeature.P2PTunnelRedstone), (Set)EnumSet.noneOf(IntegrationType.class), (Class)PartP2PRedstone.class, GuiText.RedstoneTunnel){

        @Override
        String getUnlocalizedName() {
            return "P2PTunnel";
        }
    }
    ,
    P2PTunnelItems(462, "p2p_tunnel_items", (Set)EnumSet.of(AEFeature.P2PTunnel, AEFeature.P2PTunnelItems), (Set)EnumSet.noneOf(IntegrationType.class), (Class)PartP2PItems.class, GuiText.ItemTunnel){

        @Override
        String getUnlocalizedName() {
            return "P2PTunnel";
        }
    }
    ,
    P2PTunnelLiquids(463, "p2p_tunnel_liquids", (Set)EnumSet.of(AEFeature.P2PTunnel, AEFeature.P2PTunnelLiquids), (Set)EnumSet.noneOf(IntegrationType.class), (Class)PartP2PLiquids.class, GuiText.FluidTunnel){

        @Override
        String getUnlocalizedName() {
            return "P2PTunnel";
        }
    }
    ,
    P2PTunnelLight(467, "p2p_tunnel_light", (Set)EnumSet.of(AEFeature.P2PTunnel, AEFeature.P2PTunnelLight), (Set)EnumSet.noneOf(IntegrationType.class), (Class)PartP2PLight.class, GuiText.LightTunnel){

        @Override
        String getUnlocalizedName() {
            return "P2PTunnel";
        }
    }
    ,
    InterfaceTerminal(480, "interface_terminal", EnumSet.of(AEFeature.InterfaceTerminal), EnumSet.noneOf(IntegrationType.class), PartInterfaceTerminal.class);

    private final int baseDamage;
    private final Set<AEFeature> features;
    private final Set<IntegrationType> integrations;
    private final Class<? extends IPart> myPart;
    private final GuiText extraName;
    @SideOnly(value=Side.CLIENT)
    private List<ModelResourceLocation> itemModels;
    private final Set<ResourceLocation> models;
    private Constructor<? extends IPart> constructor;

    private PartType(int baseMetaValue, String itemModel, Set<AEFeature> features, Set<IntegrationType> integrations, Class<? extends IPart> c) {
        this(baseMetaValue, itemModel, features, integrations, c, null);
    }

    private PartType(int baseMetaValue, String itemModel, Set<AEFeature> features, Set<IntegrationType> integrations, Class<? extends IPart> c, GuiText en) {
        this.baseDamage = baseMetaValue;
        this.features = Collections.unmodifiableSet(features);
        this.integrations = Collections.unmodifiableSet(integrations);
        this.myPart = c;
        this.extraName = en;
        if (Platform.isClient()) {
            this.itemModels = this.createItemModels(itemModel);
        }
        this.models = c != null ? new HashSet<ResourceLocation>(PartModelsHelper.createModels(c)) : Collections.emptySet();
    }

    @SideOnly(value=Side.CLIENT)
    protected List<ModelResourceLocation> createItemModels(String baseName) {
        return ImmutableList.of((Object)PartType.modelFromBaseName(baseName));
    }

    @SideOnly(value=Side.CLIENT)
    private static ModelResourceLocation modelFromBaseName(String baseName) {
        return new ModelResourceLocation(new ResourceLocation("appliedenergistics2", "part/" + baseName), "inventory");
    }

    int getBaseDamage() {
        return this.baseDamage;
    }

    public boolean isCable() {
        return false;
    }

    Set<AEFeature> getFeature() {
        return this.features;
    }

    Set<IntegrationType> getIntegrations() {
        return this.integrations;
    }

    Class<? extends IPart> getPart() {
        return this.myPart;
    }

    String getUnlocalizedName() {
        return this.name();
    }

    GuiText getExtraName() {
        return this.extraName;
    }

    Constructor<? extends IPart> getConstructor() {
        return this.constructor;
    }

    void setConstructor(Constructor<? extends IPart> constructor) {
        this.constructor = constructor;
    }

    @SideOnly(value=Side.CLIENT)
    public List<ModelResourceLocation> getItemModels() {
        return this.itemModels;
    }

    public Set<ResourceLocation> getModels() {
        return this.models;
    }
}

