/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.IGridHost;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.INetworkToolAgent;
import appeng.client.ClientHelper;
import appeng.container.AEBaseContainer;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketClick;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolViewer;
import appeng.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ToolNetworkTool
extends AEBaseItem
implements IGuiItem,
IAEWrench {
    public ToolNetworkTool() {
        this.func_77625_d(1);
        this.setHarvestLevel("wrench", 0);
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return new NetworkToolViewer(is, (IGridHost)(te instanceof IGridHost ? te : null));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack it, World w, EntityPlayer p, EnumHand hand) {
        if (Platform.isClient()) {
            RayTraceResult mop = ClientHelper.proxy.getRTR();
            if (mop == null) {
                this.onItemUseFirst(it, p, w, new BlockPos(0, 0, 0), null, 0.0f, 0.0f, 0.0f, hand);
            } else if (w.func_180495_p(mop.func_178782_a()).func_177230_c().isAir(w.func_180495_p(mop.func_178782_a()), (IBlockAccess)w, mop.func_178782_a())) {
                this.onItemUseFirst(it, p, w, new BlockPos(0, 0, 0), null, 0.0f, 0.0f, 0.0f, hand);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)it);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        RayTraceResult mop = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPartHost) {
            SelectedPart part = ((IPartHost)te).selectPart(mop.field_72307_f);
            if (part.part != null && part.part instanceof INetworkToolAgent && !((INetworkToolAgent)((Object)part.part)).showNetworkInfo(mop)) {
                return EnumActionResult.FAIL;
            }
        } else if (te instanceof INetworkToolAgent && !((INetworkToolAgent)te).showNetworkInfo(mop)) {
            return EnumActionResult.FAIL;
        }
        if (Platform.isClient()) {
            NetworkHandler.instance.sendToServer(new PacketClick(pos, side, hitX, hitY, hitZ, hand));
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(ItemStack itemstack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean serverSideToolLogic(ItemStack is, EntityPlayer p, EnumHand hand, World w, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side != null) {
            TileEntity te;
            if (!Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
                return false;
            }
            Block b = w.func_180495_p(pos).func_177230_c();
            if (!p.func_70093_af() && !((te = w.func_175625_s(pos)) instanceof IGridHost) && b.rotateBlock(w, pos, side)) {
                b.func_189540_a(Platform.AIR_BLOCK.func_176223_P(), w, pos, Platform.AIR_BLOCK);
                p.func_184609_a(hand);
                return !w.field_72995_K;
            }
            if (!p.func_70093_af()) {
                if (p.field_71070_bA instanceof AEBaseContainer) {
                    return true;
                }
                te = w.func_175625_s(pos);
                if (te instanceof IGridHost) {
                    Platform.openGUI(p, te, AEPartLocation.fromFacing(side), GuiBridge.GUI_NETWORK_STATUS);
                } else {
                    Platform.openGUI(p, null, AEPartLocation.INTERNAL, GuiBridge.GUI_NETWORK_TOOL);
                }
                return true;
            }
            b.func_180639_a(w, pos, w.func_180495_p(pos), p, hand, is, side, hitX, hitY, hitZ);
        } else {
            Platform.openGUI(p, null, AEPartLocation.INTERNAL, GuiBridge.GUI_NETWORK_TOOL);
        }
        return false;
    }

    @Override
    public boolean canWrench(ItemStack wrench, EntityPlayer player, BlockPos pos) {
        return true;
    }
}

