/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMatterCannon;
import appeng.hooks.TickHandler;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.ItemPaintBall;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.storage.CellInventoryHandler;
import appeng.tile.misc.TilePaint;
import appeng.util.LookDirection;
import appeng.util.Platform;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ToolMatterCannon
extends AEBasePoweredItem
implements IStorageCell {
    public ToolMatterCannon() {
        super(AEConfig.instance.matterCannonBattery);
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICellInventory cd;
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        IMEInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
        if (cdi instanceof CellInventoryHandler && (cd = ((ICellInventoryHandler)cdi).getCellInv()) != null) {
            lines.add(cd.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cd.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(cd.getStoredItemTypes() + " " + GuiText.Of.getLocal() + ' ' + cd.getTotalItemTypes() + ' ' + GuiText.Types.getLocal());
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack item, World w, EntityPlayer p, @Nullable EnumHand hand) {
        if (this.getAECurrentPower(item) > 1600.0) {
            IMEInventoryHandler inv;
            int shots = 1;
            CellUpgrades cu = (CellUpgrades)this.getUpgradesInventory(item);
            if (cu != null) {
                shots += cu.getInstalledUpgrades(Upgrades.SPEED);
            }
            if ((inv = AEApi.instance().registries().cell().getCellInventory(item, null, StorageChannel.ITEMS)) != null) {
                IItemList<IAEItemStack> itemList = inv.getAvailableItems(AEApi.instance().storage().createItemList());
                IAEItemStack aeAmmo = itemList.getFirstItem();
                if (aeAmmo instanceof IAEItemStack) {
                    shots = Math.min(shots, (int)aeAmmo.getStackSize());
                    for (int sh = 0; sh < shots; ++sh) {
                        this.extractAEPower(item, 1600.0);
                        if (Platform.isClient()) {
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
                        }
                        aeAmmo.setStackSize(1L);
                        ItemStack ammo = aeAmmo.getItemStack();
                        if (ammo == null) {
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
                        }
                        ammo.field_77994_a = 1;
                        if ((aeAmmo = inv.extractItems(aeAmmo, Actionable.MODULATE, new PlayerSource(p, null))) == null) {
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
                        }
                        LookDirection dir = Platform.getPlayerRay(p, p.func_70047_e());
                        Vec3d Vec3d2 = dir.getA();
                        Vec3d Vec3d1 = dir.getB();
                        Vec3d direction = Vec3d1.func_178788_d(Vec3d2);
                        direction.func_72432_b();
                        double d0 = Vec3d2.field_72450_a;
                        double d1 = Vec3d2.field_72448_b;
                        double d2 = Vec3d2.field_72449_c;
                        float penetration = AEApi.instance().registries().matterCannon().getPenetration(ammo);
                        if (penetration <= 0.0f) {
                            ItemStack type = aeAmmo.getItemStack();
                            if (type.func_77973_b() instanceof ItemPaintBall) {
                                this.shootPaintBalls(type, w, p, Vec3d2, Vec3d1, direction, d0, d1, d2);
                            }
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
                        }
                        this.standardAmmo(penetration, w, p, Vec3d2, Vec3d1, direction, d0, d1, d2);
                    }
                } else {
                    if (Platform.isServer()) {
                        p.func_145747_a(PlayerMessages.AmmoDepleted.get());
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
                }
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)item);
    }

    private void shootPaintBalls(ItemStack type, World w, EntityPlayer p, Vec3d Vec3d2, Vec3d Vec3d1, Vec3d direction, double d0, double d1, double d2) {
        AxisAlignedBB bb = new AxisAlignedBB(Math.min(Vec3d2.field_72450_a, Vec3d1.field_72450_a), Math.min(Vec3d2.field_72448_b, Vec3d1.field_72448_b), Math.min(Vec3d2.field_72449_c, Vec3d1.field_72449_c), Math.max(Vec3d2.field_72450_a, Vec3d1.field_72450_a), Math.max(Vec3d2.field_72448_b, Vec3d1.field_72448_b), Math.max(Vec3d2.field_72449_c, Vec3d1.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
        Entity entity = null;
        List list = w.func_72839_b((Entity)p, bb);
        double closest = 9999999.0;
        for (int l = 0; l < list.size(); ++l) {
            double nd;
            Entity entity1 = (Entity)list.get(l);
            if (entity1.field_70128_L || entity1 == p || entity1 instanceof EntityItem || !entity1.func_70089_S() || entity1.func_184215_y((Entity)p)) continue;
            float f1 = 0.3f;
            AxisAlignedBB boundingBox = entity1.func_174813_aQ().func_72314_b((double)0.3f, (double)0.3f, (double)0.3f);
            RayTraceResult RayTraceResult2 = boundingBox.func_72327_a(Vec3d2, Vec3d1);
            if (RayTraceResult2 == null || !((nd = Vec3d2.func_72436_e(RayTraceResult2.field_72307_f)) < closest)) continue;
            entity = entity1;
            closest = nd;
        }
        RayTraceResult pos = w.func_72901_a(Vec3d2, Vec3d1, false);
        Vec3d vec = new Vec3d(d0, d1, d2);
        if (entity != null && pos != null && pos.field_72307_f.func_72436_e(vec) > closest) {
            pos = new RayTraceResult(entity);
        } else if (entity != null && pos == null) {
            pos = new RayTraceResult(entity);
        }
        try {
            CommonHelper.proxy.sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new PacketMatterCannon(d0, d1, d2, (float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c, (byte)(pos == null ? 32.0 : pos.field_72307_f.func_72436_e(vec) + 1.0)));
        }
        catch (Exception err) {
            AELog.debug(err);
        }
        if (pos != null && type != null && type.func_77973_b() instanceof ItemPaintBall) {
            ItemPaintBall ipb = (ItemPaintBall)type.func_77973_b();
            AEColor col = ipb.getColor(type);
            if (pos.field_72313_a == RayTraceResult.Type.ENTITY) {
                int id = pos.field_72308_g.func_145782_y();
                TickHandler.PlayerColor marker = new TickHandler.PlayerColor(id, col, 600);
                TickHandler.INSTANCE.getPlayerColors().put(id, marker);
                if (pos.field_72308_g instanceof EntitySheep) {
                    EntitySheep sh = (EntitySheep)pos.field_72308_g;
                    sh.func_175512_b(col.dye);
                }
                pos.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)p), 0.0f);
                NetworkHandler.instance.sendToAll(marker.getPacket());
            } else if (pos.field_72313_a == RayTraceResult.Type.BLOCK) {
                TileEntity te;
                EnumFacing side = pos.field_178784_b;
                BlockPos hitPos = pos.func_178782_a().func_177972_a(side);
                if (!Platform.hasPermissions(new DimensionalCoord(w, hitPos), p)) {
                    return;
                }
                Block whatsThere = w.func_180495_p(hitPos).func_177230_c();
                if (whatsThere.func_176200_f((IBlockAccess)w, hitPos) && w.func_175623_d(hitPos)) {
                    AEApi.instance().definitions().blocks().paint().maybeBlock().ifPresent(paintBlock -> w.func_180501_a(hitPos, paintBlock.func_176223_P(), 3));
                }
                if ((te = w.func_175625_s(hitPos)) instanceof TilePaint) {
                    Vec3d hp = pos.field_72307_f.func_178786_a((double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p());
                    ((TilePaint)te).addBlot(type, side.func_176734_d(), hp);
                }
            }
        }
    }

    private void standardAmmo(float penetration, World w, EntityPlayer p, Vec3d Vec3d2, Vec3d Vec3d1, Vec3d direction, double d0, double d1, double d2) {
        boolean hasDestroyed = true;
        while (penetration > 0.0f && hasDestroyed) {
            hasDestroyed = false;
            AxisAlignedBB bb = new AxisAlignedBB(Math.min(Vec3d2.field_72450_a, Vec3d1.field_72450_a), Math.min(Vec3d2.field_72448_b, Vec3d1.field_72448_b), Math.min(Vec3d2.field_72449_c, Vec3d1.field_72449_c), Math.max(Vec3d2.field_72450_a, Vec3d1.field_72450_a), Math.max(Vec3d2.field_72448_b, Vec3d1.field_72448_b), Math.max(Vec3d2.field_72449_c, Vec3d1.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
            Entity entity = null;
            List list = w.func_72839_b((Entity)p, bb);
            double closest = 9999999.0;
            for (int l = 0; l < list.size(); ++l) {
                double nd;
                Entity entity1 = (Entity)list.get(l);
                if (entity1.field_70128_L || entity1 == p || entity1 instanceof EntityItem || !entity1.func_70089_S() || entity1.func_184215_y((Entity)p)) continue;
                float f1 = 0.3f;
                AxisAlignedBB boundingBox = entity1.func_174813_aQ().func_72314_b((double)0.3f, (double)0.3f, (double)0.3f);
                RayTraceResult RayTraceResult2 = boundingBox.func_72327_a(Vec3d2, Vec3d1);
                if (RayTraceResult2 == null || !((nd = Vec3d2.func_72436_e(RayTraceResult2.field_72307_f)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
            Vec3d vec = new Vec3d(d0, d1, d2);
            RayTraceResult pos = w.func_72901_a(Vec3d2, Vec3d1, true);
            if (entity != null && pos != null && pos.field_72307_f.func_72436_e(vec) > closest) {
                pos = new RayTraceResult(entity);
            } else if (entity != null && pos == null) {
                pos = new RayTraceResult(entity);
            }
            try {
                CommonHelper.proxy.sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new PacketMatterCannon(d0, d1, d2, (float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c, (byte)(pos == null ? 32.0 : pos.field_72307_f.func_72436_e(vec) + 1.0)));
            }
            catch (Exception err) {
                AELog.debug(err);
            }
            if (pos == null) continue;
            DamageSource dmgSrc = DamageSource.func_76365_a((EntityPlayer)p);
            dmgSrc.field_76373_n = "matter_cannon";
            if (pos.field_72313_a == RayTraceResult.Type.ENTITY) {
                int dmg = (int)Math.ceil(penetration / 20.0f);
                if (pos.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase el = (EntityLivingBase)pos.field_72308_g;
                    penetration -= (float)dmg;
                    el.func_70653_a((Entity)p, 0.0f, -direction.field_72450_a, -direction.field_72449_c);
                    el.func_70097_a(dmgSrc, (float)dmg);
                    if (el.func_70089_S()) continue;
                    hasDestroyed = true;
                    continue;
                }
                if (pos.field_72308_g instanceof EntityItem) {
                    hasDestroyed = true;
                    pos.field_72308_g.func_70106_y();
                    continue;
                }
                if (!pos.field_72308_g.func_70097_a(dmgSrc, (float)dmg)) continue;
                hasDestroyed = true;
                continue;
            }
            if (pos.field_72313_a != RayTraceResult.Type.BLOCK) continue;
            if (!AEConfig.instance.isFeatureEnabled(AEFeature.MassCannonBlockDamage)) {
                penetration = 0.0f;
                continue;
            }
            IBlockState bs = w.func_180495_p(pos.func_178782_a());
            float hardness = bs.func_185887_b(w, pos.func_178782_a()) * 9.0f;
            if (!((double)hardness >= 0.0) || !(penetration > hardness) || !Platform.hasPermissions(new DimensionalCoord(w, pos.func_178782_a()), p)) continue;
            hasDestroyed = true;
            penetration -= hardness;
            penetration = (float)((double)penetration * 0.6);
            w.func_175655_b(pos.func_178782_a(), true);
        }
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 4);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 1;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        float pen = AEApi.instance().registries().matterCannon().getPenetration(requestedAddition.getItemStack());
        if (pen > 0.0f) {
            return false;
        }
        return !(requestedAddition.getItem() instanceof ItemPaintBall);
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }
}

