/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.items.parts.PartModels;
import appeng.parts.automation.PartAnnihilationPlane;
import appeng.parts.automation.PlaneModels;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class PartIdentityAnnihilationPlane
extends PartAnnihilationPlane {
    private static final PlaneModels MODELS = new PlaneModels("part/identity_annihilation_plane_", "part/identity_annihilation_plane_on_");
    private static final float SILK_TOUCH_FACTOR = 16.0f;

    @PartModels
    public static List<ResourceLocation> getModels() {
        return MODELS.getModels();
    }

    public PartIdentityAnnihilationPlane(ItemStack is) {
        super(is);
    }

    @Override
    protected boolean isAnnihilationPlane(TileEntity blockTileEntity, AEPartLocation side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p != null && p.getClass() == this.getClass();
        }
        return false;
    }

    @Override
    protected float calculateEnergyUsage(WorldServer w, BlockPos pos, List<ItemStack> items) {
        float requiredEnergy = super.calculateEnergyUsage(w, pos, items);
        return requiredEnergy * 16.0f;
    }

    @Override
    protected List<ItemStack> obtainBlockDrops(WorldServer w, BlockPos pos) {
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)w);
        IBlockState state = w.func_180495_p(pos);
        if (state.func_177230_c().canSilkHarvest((World)w, pos, state, (EntityPlayer)fakePlayer)) {
            ArrayList<ItemStack> out = new ArrayList<ItemStack>(1);
            Item item = Item.func_150898_a((Block)state.func_177230_c());
            if (item != null) {
                int meta = 0;
                if (item.func_77614_k()) {
                    meta = state.func_177230_c().func_176201_c(state);
                }
                ItemStack itemstack = new ItemStack(item, 1, meta);
                out.add(itemstack);
            }
            return out;
        }
        return super.obtainBlockDrops(w, pos);
    }

    @Override
    public List<ResourceLocation> getStaticModels() {
        return MODELS.getModel(this.getConnections(), this.isPowered(), this.isActive());
    }
}

