/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyWatcher;
import appeng.api.networking.energy.IEnergyWatcherHost;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.core.sync.GuiBridge;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PartLevelEmitter
extends PartUpgradeable
implements IEnergyWatcherHost,
IStackWatcherHost,
ICraftingWatcherHost,
IMEMonitorHandlerReceiver<IAEItemStack>,
ICraftingProvider {
    @PartModels
    public static final ResourceLocation MODEL_BASE_OFF = new ResourceLocation("appliedenergistics2", "part/level_emitter_base_off");
    @PartModels
    public static final ResourceLocation MODEL_BASE_ON = new ResourceLocation("appliedenergistics2", "part/level_emitter_base_on");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_OFF = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_off");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_ON = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_on");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_HAS_CHANNEL = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_has_channel");
    public static final List<ResourceLocation> MODEL_OFF_OFF = ImmutableList.of((Object)MODEL_BASE_OFF, (Object)MODEL_STATUS_OFF);
    public static final List<ResourceLocation> MODEL_OFF_ON = ImmutableList.of((Object)MODEL_BASE_OFF, (Object)MODEL_STATUS_ON);
    public static final List<ResourceLocation> MODEL_OFF_HAS_CHANNEL = ImmutableList.of((Object)MODEL_BASE_OFF, (Object)MODEL_STATUS_HAS_CHANNEL);
    public static final List<ResourceLocation> MODEL_ON_OFF = ImmutableList.of((Object)MODEL_BASE_ON, (Object)MODEL_STATUS_OFF);
    public static final List<ResourceLocation> MODEL_ON_ON = ImmutableList.of((Object)MODEL_BASE_ON, (Object)MODEL_STATUS_ON);
    public static final List<ResourceLocation> MODEL_ON_HAS_CHANNEL = ImmutableList.of((Object)MODEL_BASE_ON, (Object)MODEL_STATUS_HAS_CHANNEL);
    private static final int FLAG_ON = 4;
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 1);
    private boolean prevState = false;
    private long lastReportedValue = 0L;
    private long reportingValue = 0L;
    private IStackWatcher myWatcher;
    private IEnergyWatcher myEnergyWatcher;
    private ICraftingWatcher myCraftingWatcher;
    private double centerX;
    private double centerY;
    private double centerZ;

    public PartLevelEmitter(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, RedstoneMode.HIGH_SIGNAL);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.getConfigManager().registerSetting(Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long v) {
        this.reportingValue = v;
        if (this.getConfigManager().getSetting(Settings.LEVEL_TYPE) == LevelType.ENERGY_LEVEL) {
            this.configureWatchers();
        } else {
            this.updateState();
        }
    }

    @MENetworkEventSubscribe
    public void powerChanged(MENetworkPowerStatusChange c) {
        this.updateState();
    }

    private void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.getHost().markForUpdate();
            TileEntity te = this.getHost().getTile();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors(te.func_145831_w(), te.func_174877_v());
            Platform.notifyBlocksOfNeighbors(te.func_145831_w(), te.func_174877_v().func_177972_a(this.getSide().getFacing()));
        }
    }

    public boolean isLevelEmitterOn() {
        boolean flipState;
        if (Platform.isClient()) {
            return (this.getClientFlags() & 4) == 4;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0) {
            try {
                return this.getProxy().getCrafting().isRequesting(this.config.getAEStackInSlot(0));
            }
            catch (GridAccessException gridAccessException) {
                return this.prevState;
            }
        }
        boolean bl = flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        return flipState ? this.reportingValue >= this.lastReportedValue + 1L : this.reportingValue < this.lastReportedValue + 1L;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        this.updateState();
    }

    @Override
    protected int populateFlags(int cf) {
        return cf | (this.prevState ? 4 : 0);
    }

    @Override
    public void updateWatcher(ICraftingWatcher newWatcher) {
        this.myCraftingWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onRequestChange(ICraftingGrid craftingGrid, IAEItemStack what) {
        this.updateState();
    }

    private void configureWatchers() {
        IAEItemStack myStack = this.config.getAEStackInSlot(0);
        if (this.myWatcher != null) {
            this.myWatcher.clear();
        }
        if (this.myEnergyWatcher != null) {
            this.myEnergyWatcher.clear();
        }
        if (this.myCraftingWatcher != null) {
            this.myCraftingWatcher.clear();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0) {
            if (this.myCraftingWatcher != null && myStack != null) {
                this.myCraftingWatcher.add(myStack);
            }
            return;
        }
        if (this.getConfigManager().getSetting(Settings.LEVEL_TYPE) == LevelType.ENERGY_LEVEL) {
            if (this.myEnergyWatcher != null) {
                this.myEnergyWatcher.add(Double.valueOf(this.reportingValue));
            }
            try {
                this.lastReportedValue = (long)this.getProxy().getEnergy().getStoredPower();
                this.updateState();
                this.getProxy().getStorage().getItemInventory().removeListener(this);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return;
        }
        try {
            if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0 || myStack == null) {
                this.getProxy().getStorage().getItemInventory().addListener(this, this.getProxy().getGrid());
            } else {
                this.getProxy().getStorage().getItemInventory().removeListener(this);
                if (this.myWatcher != null) {
                    this.myWatcher.add(myStack);
                }
            }
            this.updateReportingValue(this.getProxy().getStorage().getItemInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateReportingValue(IMEMonitor<IAEItemStack> monitor) {
        IAEItemStack myStack = this.config.getAEStackInSlot(0);
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (IAEItemStack st : monitor.getStorageList()) {
                this.lastReportedValue += st.getStackSize();
            }
        } else if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.lastReportedValue = 0L;
            FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
            Collection<IAEItemStack> fuzzyList = monitor.getStorageList().findFuzzy(myStack, fzMode);
            for (IAEItemStack st : fuzzyList) {
                this.lastReportedValue += st.getStackSize();
            }
        } else {
            IAEItemStack r = monitor.getStorageList().findPrecise(myStack);
            this.lastReportedValue = r == null ? 0L : r.getStackSize();
        }
        this.updateState();
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (chan == StorageChannel.ITEMS && fullStack.equals(this.config.getAEStackInSlot(0)) && this.getInstalledUpgrades(Upgrades.FUZZY) == 0) {
            this.lastReportedValue = fullStack.getStackSize();
            this.updateState();
        }
    }

    @Override
    public void updateWatcher(IEnergyWatcher newWatcher) {
        this.myEnergyWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onThresholdPass(IEnergyGrid energyGrid) {
        this.lastReportedValue = (long)energyGrid.getStoredPower();
        this.updateState();
    }

    @Override
    public boolean isValid(Object effectiveGrid) {
        try {
            return this.getProxy().getGrid() == effectiveGrid;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        this.updateReportingValue((IMEMonitor)monitor);
    }

    @Override
    public void onListUpdate() {
        try {
            this.updateReportingValue(this.getProxy().getStorage().getItemInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public void randomDisplayTick(World world, BlockPos pos, Random r) {
        if (this.isLevelEmitterOn()) {
            AEPartLocation d = this.getSide();
            double d0 = (double)((float)d.xOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.yOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.zOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_175688_a(EnumParticleTypes.REDSTONE, 0.5 + (double)pos.func_177958_n() + d0, 0.5 + (double)pos.func_177956_o() + d1, 0.5 + (double)pos.func_177952_p() + d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_LEVEL_EMITTER);
            return true;
        }
        return false;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.configureWatchers();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.config) {
            this.configureWatchers();
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    @Override
    public void upgradesChanged() {
        this.configureWatchers();
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.func_74763_f("lastReportedValue");
        this.reportingValue = data.func_74763_f("reportingValue");
        this.prevState = data.func_74767_n("prevState");
        this.config.readFromNBT(data, "config");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74772_a("lastReportedValue", this.lastReportedValue);
        data.func_74772_a("reportingValue", this.reportingValue);
        data.func_74757_a("prevState", this.prevState);
        this.config.writeToNBT(data, "config");
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return false;
    }

    @Override
    public boolean isBusy() {
        return true;
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        IAEItemStack what;
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0 && this.getConfigManager().getSetting(Settings.CRAFT_VIA_REDSTONE) == YesNo.YES && (what = this.config.getAEStackInSlot(0)) != null) {
            craftingTracker.setEmitable(what);
        }
    }

    @Override
    public List<ResourceLocation> getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_HAS_CHANNEL : MODEL_OFF_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_ON : MODEL_OFF_ON;
        }
        return this.isLevelEmitterOn() ? MODEL_ON_OFF : MODEL_OFF_OFF;
    }
}

