/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.parts.automation.PlaneConnections;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

class PlaneModels {
    public static final ResourceLocation MODEL_CHASSIS_OFF = new ResourceLocation("appliedenergistics2", "part/transition_plane_off");
    public static final ResourceLocation MODEL_CHASSIS_ON = new ResourceLocation("appliedenergistics2", "part/transition_plane_on");
    public static final ResourceLocation MODEL_CHASSIS_HAS_CHANNEL = new ResourceLocation("appliedenergistics2", "part/transition_plane_has_channel");
    private final Map<PlaneConnections, List<ResourceLocation>> modelsOff;
    private final Map<PlaneConnections, List<ResourceLocation>> modelsOn;
    private final Map<PlaneConnections, List<ResourceLocation>> modelsHasChannel;

    public PlaneModels(String prefixOff, String prefixOn) {
        HashMap<PlaneConnections, ImmutableList> modelsOff = new HashMap<PlaneConnections, ImmutableList>();
        HashMap<PlaneConnections, ImmutableList> modelsOn = new HashMap<PlaneConnections, ImmutableList>();
        HashMap<PlaneConnections, ImmutableList> modelsHasChannel = new HashMap<PlaneConnections, ImmutableList>();
        for (PlaneConnections permutation : PlaneConnections.PERMUTATIONS) {
            ResourceLocation planeOff = new ResourceLocation("appliedenergistics2", prefixOff + permutation.getFilenameSuffix());
            ResourceLocation planeOn = new ResourceLocation("appliedenergistics2", prefixOn + permutation.getFilenameSuffix());
            modelsOff.put(permutation, ImmutableList.of((Object)MODEL_CHASSIS_OFF, (Object)planeOff));
            modelsOn.put(permutation, ImmutableList.of((Object)MODEL_CHASSIS_ON, (Object)planeOff));
            modelsHasChannel.put(permutation, ImmutableList.of((Object)MODEL_CHASSIS_HAS_CHANNEL, (Object)planeOn));
        }
        this.modelsOff = ImmutableMap.copyOf(modelsOff);
        this.modelsOn = ImmutableMap.copyOf(modelsOn);
        this.modelsHasChannel = ImmutableMap.copyOf(modelsHasChannel);
    }

    public List<ResourceLocation> getModel(PlaneConnections connections, boolean hasPower, boolean hasChannel) {
        if (hasPower && hasChannel) {
            return this.modelsHasChannel.get(connections);
        }
        if (hasPower) {
            return this.modelsOn.get(connections);
        }
        return this.modelsOff.get(connections);
    }

    public List<ResourceLocation> getModels() {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        this.modelsOff.values().forEach(result::addAll);
        this.modelsOn.values().forEach(result::addAll);
        this.modelsHasChannel.values().forEach(result::addAll);
        return result;
    }
}

