/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.LayerBase;
import appeng.api.util.AEPartLocation;
import appeng.parts.layers.InvLayerData;
import appeng.parts.layers.InvSot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;

public class LayerISidedInventory
extends LayerBase
implements ISidedInventory {
    private static final int[] NULL_SIDES = new int[0];
    private InvLayerData invLayer = null;

    @Override
    public void notifyNeighbors() {
        Object sideData = null;
        ArrayList<ISidedInventory> inventories = null;
        ArrayList<InvSot> slots = null;
        inventories = new ArrayList<ISidedInventory>();
        int slotCount = 0;
        for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
            IPart bp = this.getPart(side);
            if (!(bp instanceof ISidedInventory)) continue;
            AEPartLocation[] part = (AEPartLocation[])bp;
            slotCount += part.func_70302_i_();
            inventories.add((ISidedInventory)part);
        }
        if (inventories.isEmpty() || slotCount == 0) {
            inventories = null;
        } else {
            sideData = new int[][]{NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES, NULL_SIDES};
            slots = new ArrayList<InvSot>(Collections.nCopies(slotCount, null));
            int offsetForLayer = 0;
            int offsetForPart = 0;
            for (ISidedInventory sides : inventories) {
                offsetForPart = 0;
                slotCount = sides.func_70302_i_();
                AEPartLocation currentSide = AEPartLocation.INTERNAL;
                for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                    if (this.getPart(side) != sides) continue;
                    currentSide = side;
                    break;
                }
                int[] nArray = new int[slotCount];
                sideData[currentSide.ordinal()] = nArray;
                int[] cSidesList = nArray;
                for (int cSlot = 0; cSlot < slotCount; ++cSlot) {
                    cSidesList[cSlot] = offsetForLayer;
                    slots.set(offsetForLayer, new InvSot(sides, offsetForPart));
                    ++offsetForLayer;
                    ++offsetForPart;
                }
            }
        }
        this.invLayer = sideData == null || slots == null ? null : new InvLayerData((int[][])sideData, (List<ISidedInventory>)inventories, (List<InvSot>)slots);
        super.notifyNeighbors();
    }

    public int func_70302_i_() {
        if (this.invLayer == null) {
            return 0;
        }
        return this.invLayer.getSizeInventory();
    }

    public ItemStack func_70301_a(int slot) {
        if (this.invLayer == null) {
            return null;
        }
        return this.invLayer.getStackInSlot(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.invLayer == null) {
            return null;
        }
        return this.invLayer.decreaseStackSize(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (this.invLayer == null) {
            return;
        }
        this.invLayer.setInventorySlotContents(slot, itemstack);
    }

    public String func_70005_c_() {
        return "AEMultiPart";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.isItemValidForSlot(slot, itemstack);
    }

    public void func_70296_d() {
        if (this.invLayer != null) {
            this.invLayer.markDirty();
        }
        super.markForSave();
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.invLayer != null) {
            return this.invLayer.getSlotsForFace(side);
        }
        return NULL_SIDES;
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing side) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.canInsertItem(slot, itemstack, side);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        if (this.invLayer == null) {
            return false;
        }
        return this.invLayer.canExtractItem(slot, itemstack, side);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

