/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

class P2PModels {
    public static final ResourceLocation MODEL_STATUS_OFF = new ResourceLocation("appliedenergistics2", "part/p2p/p2p_tunnel_status_off");
    public static final ResourceLocation MODEL_STATUS_ON = new ResourceLocation("appliedenergistics2", "part/p2p/p2p_tunnel_status_on");
    public static final ResourceLocation MODEL_STATUS_HAS_CHANNEL = new ResourceLocation("appliedenergistics2", "part/p2p/p2p_tunnel_status_has_channel");
    private final List<ResourceLocation> modelsOff;
    private final List<ResourceLocation> modelsOn;
    private final List<ResourceLocation> modelsHasChannel;

    public P2PModels(String frontModelPath) {
        ResourceLocation frontModel = new ResourceLocation("appliedenergistics2", frontModelPath);
        this.modelsOff = ImmutableList.of((Object)MODEL_STATUS_OFF, (Object)frontModel);
        this.modelsOn = ImmutableList.of((Object)MODEL_STATUS_ON, (Object)frontModel);
        this.modelsHasChannel = ImmutableList.of((Object)MODEL_STATUS_HAS_CHANNEL, (Object)frontModel);
    }

    public List<ResourceLocation> getModel(boolean hasPower, boolean hasChannel) {
        if (hasPower && hasChannel) {
            return this.modelsHasChannel;
        }
        if (hasPower) {
            return this.modelsOn;
        }
        return this.modelsOff;
    }

    public List<ResourceLocation> getModels() {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        result.addAll(this.modelsOff);
        result.addAll(this.modelsOn);
        result.addAll(this.modelsHasChannel);
        return result;
    }
}

