/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PartP2PLiquids
extends PartP2PTunnel<PartP2PLiquids>
implements IFluidHandler {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_liquids");
    private static final ThreadLocal<Stack<PartP2PLiquids>> DEPTH = new ThreadLocal();
    private static final FluidTankInfo[] ACTIVE_TANK = new FluidTankInfo[]{new FluidTankInfo(null, 10000)};
    private static final FluidTankInfo[] INACTIVE_TANK = new FluidTankInfo[]{new FluidTankInfo(null, 0)};
    private IFluidHandler cachedTank;
    private int tmpUsed;

    @PartModels
    public static List<ResourceLocation> getModels() {
        return MODELS.getModels();
    }

    public PartP2PLiquids(ItemStack is) {
        super(is);
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void onTunnelNetworkChange() {
        this.cachedTank = null;
    }

    @Override
    public void onNeighborChanged() {
        PartP2PLiquids in;
        this.cachedTank = null;
        if (this.isOutput() && (in = (PartP2PLiquids)this.getInput()) != null) {
            in.onTunnelNetworkChange();
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        Stack<PartP2PLiquids> stack = this.getDepth();
        for (PartP2PLiquids t : stack) {
            if (t != this) continue;
            return 0;
        }
        stack.push(this);
        List<PartP2PLiquids> list = this.getOutputs(resource.getFluid());
        int requestTotal = 0;
        Iterator<PartP2PLiquids> i = list.iterator();
        while (i.hasNext()) {
            PartP2PLiquids l = i.next();
            IFluidHandler tank = l.getTarget();
            l.tmpUsed = tank != null ? tank.fill(l.getSide().getFacing().func_176734_d(), resource.copy(), false) : 0;
            if (l.tmpUsed <= 0) {
                i.remove();
                continue;
            }
            requestTotal += l.tmpUsed;
        }
        if (requestTotal <= 0) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return 0;
        }
        if (!doFill) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return Math.min(resource.amount, requestTotal);
        }
        int available = resource.amount;
        i = list.iterator();
        int used = 0;
        while (i.hasNext()) {
            IFluidHandler tank;
            PartP2PLiquids l = i.next();
            FluidStack insert = resource.copy();
            insert.amount = (int)Math.ceil((double)insert.amount * ((double)l.tmpUsed / (double)requestTotal));
            if (insert.amount > available) {
                insert.amount = available;
            }
            l.tmpUsed = (tank = l.getTarget()) != null ? tank.fill(l.getSide().getFacing().func_176734_d(), insert.copy(), true) : 0;
            available -= insert.amount;
            used += insert.amount;
        }
        if (stack.pop() != this) {
            throw new IllegalStateException("Invalid Recursion detected.");
        }
        return used;
    }

    private Stack<PartP2PLiquids> getDepth() {
        Stack<PartP2PLiquids> s = DEPTH.get();
        if (s == null) {
            s = new Stack();
            DEPTH.set(s);
        }
        return s;
    }

    private List<PartP2PLiquids> getOutputs(Fluid input) {
        LinkedList<PartP2PLiquids> outs = new LinkedList<PartP2PLiquids>();
        try {
            for (PartP2PLiquids l : this.getOutputs()) {
                IFluidHandler handler = l.getTarget();
                if (handler == null || !handler.canFill(l.getSide().getFacing().func_176734_d(), input)) continue;
                outs.add(l);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return outs;
    }

    private IFluidHandler getTarget() {
        if (!this.getProxy().isActive()) {
            return null;
        }
        if (this.cachedTank != null) {
            return this.cachedTank;
        }
        TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(this.getSide().getFacing()));
        if (te instanceof IFluidHandler) {
            this.cachedTank = (IFluidHandler)te;
            return this.cachedTank;
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return !this.isOutput() && from == this.getSide().getFacing() && !this.getOutputs(fluid).isEmpty();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == this.getSide().getFacing()) {
            return this.getTank();
        }
        return new FluidTankInfo[0];
    }

    private FluidTankInfo[] getTank() {
        if (this.isOutput()) {
            PartP2PLiquids tun = (PartP2PLiquids)this.getInput();
            if (tun != null) {
                return ACTIVE_TANK;
            }
        } else {
            try {
                if (!this.getOutputs().isEmpty()) {
                    return ACTIVE_TANK;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return INACTIVE_TANK;
    }

    @Override
    public List<ResourceLocation> getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

