/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PartP2PRedstone
extends PartP2PTunnel<PartP2PRedstone> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_redstone");
    private int power;
    private boolean recursive = false;

    @PartModels
    public static List<ResourceLocation> getModels() {
        return MODELS.getModels();
    }

    public PartP2PRedstone(ItemStack is) {
        super(is);
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        this.setNetworkReady();
    }

    private void setNetworkReady() {
        PartP2PRedstone in;
        if (this.isOutput() && (in = (PartP2PRedstone)this.getInput()) != null) {
            this.putInput(in.power);
        }
    }

    private void putInput(Object o) {
        int newPower;
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        if (this.isOutput() && this.getProxy().isActive() && this.power != (newPower = ((Integer)o).intValue())) {
            this.power = newPower;
            this.notifyNeighbors();
        }
        this.recursive = false;
    }

    private void notifyNeighbors() {
        World worldObj = this.getTile().func_145831_w();
        Platform.notifyBlocksOfNeighbors(worldObj, this.getTile().func_174877_v());
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Platform.notifyBlocksOfNeighbors(worldObj, this.getTile().func_174877_v().func_177972_a(face));
        }
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        this.setNetworkReady();
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        this.setNetworkReady();
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.func_74762_e("power");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("power", this.power);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.setNetworkReady();
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    @Override
    public void onNeighborChanged() {
        if (!this.isOutput()) {
            BlockPos target = this.getTile().func_174877_v().func_177972_a(this.getSide().getFacing());
            IBlockState state = this.getTile().func_145831_w().func_180495_p(target);
            Block b = state.func_177230_c();
            if (b != null && !this.isOutput()) {
                EnumFacing srcSide = this.getSide().getFacing();
                if (b instanceof BlockRedstoneWire) {
                    srcSide = EnumFacing.UP;
                }
                this.power = b.func_180656_a(state, (IBlockAccess)this.getTile().func_145831_w(), target, srcSide);
                this.power = Math.max(this.power, b.func_180656_a(state, (IBlockAccess)this.getTile().func_145831_w(), target, srcSide));
                this.sendToOutput(this.power);
            } else {
                this.sendToOutput(0);
            }
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isOutput() ? this.power : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isOutput() ? this.power : 0;
    }

    private void sendToOutput(int power) {
        try {
            for (PartP2PRedstone rs : this.getOutputs()) {
                rs.putInput(power);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public List<ResourceLocation> getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

