/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IParts;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.PartBasicState;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;

public abstract class PartP2PTunnel<T extends PartP2PTunnel>
extends PartBasicState {
    private final TunnelCollection type = new TunnelCollection(null, this.getClass());
    private boolean output;
    private long freq;

    public PartP2PTunnel(ItemStack is) {
        super(is);
    }

    public TunnelCollection<T> getCollection(Collection<PartP2PTunnel> collection, Class<? extends PartP2PTunnel> c) {
        if (this.type.matches(c)) {
            this.type.setSource(collection);
            return this.type;
        }
        return null;
    }

    T getInput() {
        if (this.getFrequency() == 0L) {
            return null;
        }
        try {
            PartP2PTunnel tunnel = this.getProxy().getP2P().getInput(this.getFrequency());
            if (this.getClass().isInstance(tunnel)) {
                return (T)tunnel;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return null;
    }

    TunnelCollection<T> getOutputs() throws GridAccessException {
        if (this.getProxy().isActive()) {
            return this.getProxy().getP2P().getOutputs(this.getFrequency(), this.getClass());
        }
        return new TunnelCollection(new ArrayList(), this.getClass());
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        if (type == PartItemStack.WORLD || type == PartItemStack.NETWORK || type == PartItemStack.WRENCH || type == PartItemStack.PICK) {
            return super.getItemStack(type);
        }
        Optional<ItemStack> maybeMEStack = AEApi.instance().definitions().parts().p2PTunnelME().maybeStack(1);
        if (maybeMEStack.isPresent()) {
            return maybeMEStack.get();
        }
        return super.getItemStack(type);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setOutput(data.func_74767_n("output"));
        this.setFrequency(data.func_74763_f("freq"));
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("output", this.isOutput());
        data.func_74772_a("freq", this.getFrequency());
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public boolean useStandardMemoryCard() {
        return false;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        ItemStack is = player.field_71071_by.func_70448_g();
        TunnelType tt = AEApi.instance().registries().p2pTunnel().getTunnelTypeByItem(is);
        if (is != null && is.func_77973_b() instanceof IMemoryCard) {
            Object testPart;
            IMemoryCard mc = (IMemoryCard)is.func_77973_b();
            NBTTagCompound data = mc.getData(is);
            ItemStack newType = ItemStack.func_77949_a((NBTTagCompound)data);
            long freq = data.func_74763_f("freq");
            if (newType != null && newType.func_77973_b() instanceof IPartItem && (testPart = ((IPartItem)newType.func_77973_b()).createPartFromItemStack(newType)) instanceof PartP2PTunnel) {
                this.getHost().removePart(this.getSide(), true);
                AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof PartP2PTunnel) {
                    PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                    newTunnel.setOutput(true);
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, freq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    newTunnel.onTunnelNetworkChange();
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
        } else if (tt != null) {
            ItemStack newType;
            IParts parts = AEApi.instance().definitions().parts();
            switch (tt) {
                case LIGHT: {
                    newType = parts.p2PTunnelLight().maybeStack(1).orElse(null);
                    break;
                }
                case FLUID: {
                    newType = parts.p2PTunnelLiquids().maybeStack(1).orElse(null);
                    break;
                }
                case ITEM: {
                    newType = parts.p2PTunnelItems().maybeStack(1).orElse(null);
                    break;
                }
                case ME: {
                    newType = parts.p2PTunnelME().maybeStack(1).orElse(null);
                    break;
                }
                case REDSTONE: {
                    newType = parts.p2PTunnelRedstone().maybeStack(1).orElse(null);
                    break;
                }
                default: {
                    newType = null;
                }
            }
            if (newType != null && !Platform.isSameItem(newType, this.getItemStack())) {
                boolean oldOutput = this.isOutput();
                long myFreq = this.getFrequency();
                this.getHost().removePart(this.getSide(), false);
                AEPartLocation dir = this.getHost().addPart(newType, this.getSide(), player, hand);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof PartP2PTunnel) {
                    PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                    newTunnel.setOutput(oldOutput);
                    newTunnel.onTunnelNetworkChange();
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, myFreq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                Platform.notifyBlocksOfNeighbors(this.getTile().func_145831_w(), this.getTile().func_174877_v());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is != null && is.func_77973_b() instanceof IMemoryCard) {
            IMemoryCard mc = (IMemoryCard)is.func_77973_b();
            NBTTagCompound data = new NBTTagCompound();
            long newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            if (wasOutput || this.getFrequency() == 0L) {
                newFreq = System.currentTimeMillis();
            }
            try {
                this.getProxy().getP2P().updateFreq(this, newFreq);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            this.onTunnelConfigChange();
            ItemStack p2pItem = this.getItemStack(PartItemStack.WRENCH);
            String type = p2pItem.func_77977_a();
            p2pItem.func_77955_b(data);
            data.func_74772_a("freq", this.getFrequency());
            mc.setMemoryCardContents(is, type + ".name", data);
            mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            return true;
        }
        return false;
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        try {
            this.getProxy().getEnergy().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public long getFrequency() {
        return this.freq;
    }

    public void setFrequency(long freq) {
        this.freq = freq;
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
    }
}

