/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.render.TesrRenderHelper;
import appeng.core.localization.PlayerMessages;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractPartMonitor
extends AbstractPartDisplay
implements IPartStorageMonitor,
IStackWatcherHost {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;
    private IAEItemStack configuredItem;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher myWatcher;

    public AbstractPartMonitor(ItemStack is) {
        super(is);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isLocked = data.func_74767_n("isLocked");
        NBTTagCompound myItem = data.func_74775_l("configuredItem");
        this.configuredItem = AEItemStack.loadItemStackFromNBT(myItem);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isLocked", this.isLocked);
        NBTTagCompound myItem = new NBTTagCompound();
        if (this.configuredItem != null) {
            this.configuredItem.writeToNBT(myItem);
        }
        data.func_74782_a("configuredItem", (NBTBase)myItem);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        if (this.configuredItem != null) {
            this.configuredItem.writeToPacket(data);
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean needRedraw = super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        needRedraw = this.isLocked != isLocked;
        this.isLocked = isLocked;
        boolean val = data.readBoolean();
        this.configuredItem = val ? AEItemStack.loadItemStackFromPacket(data) : null;
        return needRedraw;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        TileEntity te = this.getTile();
        ItemStack eq = player.func_184586_b(hand);
        if (Platform.isWrench(player, eq, te.func_174877_v())) {
            this.isLocked = !this.isLocked;
            player.func_145747_a((this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).get());
            this.getHost().markForUpdate();
        } else if (!this.isLocked) {
            this.configuredItem = AEItemStack.create(eq);
            this.configureWatchers();
            this.getHost().markForUpdate();
        } else {
            this.extractItem(player);
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.clear();
        }
        try {
            if (this.configuredItem != null) {
                if (this.myWatcher != null) {
                    this.myWatcher.add(this.configuredItem);
                }
                this.updateReportingValue(this.getProxy().getStorage().getItemInventory());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void extractItem(EntityPlayer player) {
    }

    private void updateReportingValue(IMEMonitor<IAEItemStack> itemInventory) {
        if (this.configuredItem != null) {
            IAEItemStack result = itemInventory.getStorageList().findPrecise(this.configuredItem);
            if (result == null) {
                this.configuredItem.setStackSize(0L);
            } else {
                this.configuredItem.setStackSize(result.getStackSize());
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, float partialTicks, int destroyStage) {
        if ((this.getClientFlags() & 0x14) != 20) {
            return;
        }
        IAEItemStack ais = (IAEItemStack)this.getDisplayed();
        if (ais == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        EnumFacing facing = this.getSide().getFacing();
        TesrRenderHelper.moveToFace(facing);
        TesrRenderHelper.rotateToFace(facing, this.getSpin());
        TesrRenderHelper.renderItem2dWithAmount(ais, 0.8f, 0.17f);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    @Override
    public IAEStack<?> getDisplayed() {
        return this.configuredItem;
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (this.configuredItem != null) {
            if (fullStack == null) {
                this.configuredItem.setStackSize(0L);
            } else {
                this.configuredItem.setStackSize(fullStack.getStackSize());
            }
            long stackSize = this.configuredItem.getStackSize();
            String humanReadableText = NUMBER_CONVERTER.toWideReadableForm(stackSize);
            if (!humanReadableText.equals(this.lastHumanReadableText)) {
                this.lastHumanReadableText = humanReadableText;
                this.getHost().markForUpdate();
            }
        }
    }

    @Override
    public boolean showNetworkInfo(RayTraceResult where) {
        return false;
    }

    protected List<ResourceLocation> selectModel(List<ResourceLocation> off, List<ResourceLocation> on, List<ResourceLocation> hasChannel, List<ResourceLocation> lockedOff, List<ResourceLocation> lockedOn, List<ResourceLocation> lockedHasChannel) {
        if (this.isActive()) {
            if (this.isLocked()) {
                return lockedHasChannel;
            }
            return hasChannel;
        }
        if (this.isPowered()) {
            if (this.isLocked()) {
                return lockedOn;
            }
            return on;
        }
        if (this.isLocked()) {
            return lockedOff;
        }
        return off;
    }
}

