/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEPartLocation;
import appeng.api.util.WorldCoord;
import appeng.block.crafting.BlockCraftingUnit;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.AENetworkProxyMultiblock;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.util.Platform;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileCraftingTile
extends AENetworkTile
implements IAEMultiBlock,
IPowerChannelState {
    private final CraftingCPUCalculator calc = new CraftingCPUCalculator(this);
    private NBTTagCompound previousState = null;
    private boolean isCoreBlock = false;
    private CraftingCPUCluster cluster;

    public TileCraftingTile() {
        this.getProxy().setFlags(GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL);
        this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
    }

    @Override
    protected AENetworkProxy createProxy() {
        return new AENetworkProxyMultiblock(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        Optional<ItemStack> is = Optional.empty();
        if (((TileCraftingTile)obj).isAccelerator()) {
            is = AEApi.instance().definitions().blocks().craftingAccelerator().maybeStack(1);
        }
        return is.orElseGet(() -> super.getItemFromTile(obj));
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public boolean isAccelerator() {
        if (this.field_145850_b == null) {
            return false;
        }
        BlockCraftingUnit unit = (BlockCraftingUnit)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        return unit.type == BlockCraftingUnit.CraftingUnitType.ACCELERATOR;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.getProxy().setVisualRepresentation(this.getItemFromTile(this));
        this.updateMultiBlock();
    }

    public void updateMultiBlock() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    public void updateStatus(CraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateMeta(true);
    }

    public void updateMeta(boolean updateFormed) {
        IBlockState newState;
        IBlockState current;
        if (this.field_145850_b == null || this.notLoaded()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = false;
        if (this.getProxy().isReady()) {
            power = this.getProxy().isActive();
        }
        if ((current = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof BlockCraftingUnit && current != (newState = current.func_177226_a((IProperty)BlockCraftingUnit.POWERED, (Comparable)Boolean.valueOf(power)).func_177226_a((IProperty)BlockCraftingUnit.FORMED, (Comparable)Boolean.valueOf(formed)))) {
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 2);
        }
        if (updateFormed) {
            if (formed) {
                this.getProxy().setValidSides(EnumSet.allOf(EnumFacing.class));
            } else {
                this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
            }
        }
    }

    public boolean isFormed() {
        if (Platform.isClient()) {
            return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCraftingUnit.FORMED);
        }
        return this.cluster != null;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCraftingTile(NBTTagCompound data) {
        data.func_74757_a("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCraftingTile(NBTTagCompound data) {
        this.setCoreBlock(data.func_74767_n("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data);
            } else {
                this.setPreviousState(data.func_74737_b());
            }
        }
    }

    @Override
    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateMeta(true);
            }
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @MENetworkEventSubscribe
    public void onPowerStateChange(MENetworkChannelsChanged ev) {
        this.updateMeta(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStateChange(MENetworkPowerStatusChange ev) {
        this.updateMeta(false);
    }

    public boolean isStatus() {
        return false;
    }

    public boolean isStorage() {
        return false;
    }

    public int getStorageBytes() {
        return 0;
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.cancel();
            IMEInventory<IAEItemStack> inv = this.cluster.getInventory();
            LinkedList<WorldCoord> places = new LinkedList<WorldCoord>();
            Iterator<IGridHost> i = this.cluster.getTiles();
            while (i.hasNext()) {
                IGridHost h = i.next();
                if (h == this) {
                    places.add(new WorldCoord(this));
                    continue;
                }
                TileEntity te = (TileEntity)h;
                for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                    WorldCoord wc = new WorldCoord(te);
                    wc.add(d, 1);
                    if (!this.field_145850_b.func_175623_d(wc.getPos())) continue;
                    places.add(wc);
                }
            }
            Collections.shuffle(places);
            if (places.isEmpty()) {
                throw new IllegalStateException(this.cluster + " does not contain any kind of blocks, which were destroyed.");
            }
            for (IAEItemStack ais : inv.getAvailableItems(AEApi.instance().storage().createItemList())) {
                IAEItemStack g;
                ais = ais.copy();
                ais.setStackSize(ais.getItemStack().func_77976_d());
                while ((g = inv.extractItems(ais.copy(), Actionable.MODULATE, this.cluster.getActionSource())) != null) {
                    WorldCoord wc = (WorldCoord)places.poll();
                    places.add(wc);
                    Platform.spawnDrops(this.field_145850_b, wc.getPos(), Collections.singletonList(g.getItemStack()));
                }
            }
            this.cluster.destroy();
        }
    }

    @Override
    public boolean isPowered() {
        if (Platform.isClient()) {
            return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCraftingUnit.POWERED);
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isActive() {
        if (Platform.isServer()) {
            return this.getProxy().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public void setCoreBlock(boolean isCoreBlock) {
        this.isCoreBlock = isCoreBlock;
    }

    public NBTTagCompound getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(NBTTagCompound previousState) {
        this.previousState = previousState;
    }
}

