/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.qnb;

import appeng.api.AEApi;
import appeng.api.definitions.ITileDefinition;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileQuantumBridge
extends AENetworkInvTile
implements IAEMultiBlock,
ITickable {
    private final byte corner = (byte)16;
    private final int[] sidesRing = new int[0];
    private final int[] sidesLink = new int[]{0};
    private final AppEngInternalInventory internalInventory = new AppEngInternalInventory(this, 1);
    private final byte hasSingularity = (byte)32;
    private final byte powered = (byte)64;
    private final QuantumCalculator calc = new QuantumCalculator(this);
    private byte constructed = (byte)-1;
    private QuantumCluster cluster;
    private boolean updateStatus = false;

    public TileQuantumBridge() {
        this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
        this.getProxy().setFlags(GridFlags.DENSE_CAPACITY);
        this.getProxy().setIdlePowerUsage(22.0);
        this.internalInventory.setMaxStackSize(1);
    }

    @TileEvent(value=TileEventType.TICK)
    public void onTickEvent() {
        if (this.updateStatus) {
            this.updateStatus = false;
            if (this.cluster != null) {
                this.cluster.updateStatus(true);
            }
            this.markForUpdate();
        }
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void onNetworkWriteEvent(ByteBuf data) {
        int out = this.constructed;
        if (this.func_70301_a(0) != null && this.constructed != -1) {
            out |= this.hasSingularity;
        }
        if (this.getProxy().isActive() && this.constructed != -1) {
            out |= this.powered;
        }
        data.writeByte((int)((byte)out));
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean onNetworkReadEvent(ByteBuf data) {
        byte oldValue = this.constructed;
        this.constructed = data.readByte();
        return this.constructed != oldValue;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.cluster != null) {
            this.cluster.updateStatus(true);
        }
    }

    @Override
    public int[] getAccessibleSlotsBySide(EnumFacing side) {
        if (this.isCenter()) {
            return this.sidesLink;
        }
        return this.sidesRing;
    }

    private boolean isCenter() {
        return AEApi.instance().definitions().blocks().quantumLink().maybeBlock().map(link -> this.func_145838_q() == link).orElse(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        this.updateStatus = true;
    }

    @Override
    public void onChunkUnload() {
        this.disconnect(false);
        super.onChunkUnload();
    }

    @Override
    public void onReady() {
        boolean isPresent;
        super.onReady();
        ITileDefinition quantumRing = AEApi.instance().definitions().blocks().quantumRing();
        Optional<Block> maybeLinkBlock = quantumRing.maybeBlock();
        Optional<ItemStack> maybeLinkStack = quantumRing.maybeStack(1);
        boolean bl = isPresent = maybeLinkBlock.isPresent() && maybeLinkStack.isPresent();
        if (isPresent && this.func_145838_q() == maybeLinkBlock.get()) {
            ItemStack linkStack = maybeLinkStack.get();
            this.getProxy().setVisualRepresentation(linkStack);
        }
    }

    @Override
    public void func_145843_s() {
        this.disconnect(false);
        super.func_145843_s();
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.cluster != null) {
            if (!affectWorld) {
                this.cluster.setUpdateStatus(false);
            }
            this.cluster.destroy();
        }
        this.cluster = null;
        if (affectWorld) {
            this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.cluster = c;
        if (affectWorld) {
            if (this.constructed != flags) {
                this.constructed = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                EnumSet<EnumFacing> sides = EnumSet.noneOf(EnumFacing.class);
                for (EnumFacing dir : this.getAdjacentQuantumBridges()) {
                    sides.add(dir);
                }
                this.getProxy().setValidSides(sides);
            } else {
                this.getProxy().setValidSides(EnumSet.allOf(EnumFacing.class));
            }
        }
    }

    public boolean isCorner() {
        return (this.constructed & this.getCorner()) == this.getCorner() && this.constructed != -1;
    }

    public EnumSet<EnumFacing> getAdjacentQuantumBridges() {
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing d : EnumFacing.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d));
            if (!(te instanceof TileQuantumBridge)) continue;
            set.add(d);
        }
        return set;
    }

    public long getQEFrequency() {
        NBTTagCompound c;
        ItemStack is = this.internalInventory.func_70301_a(0);
        if (is != null && (c = is.func_77978_p()) != null) {
            return c.func_74763_f("freq");
        }
        return 0L;
    }

    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.constructed & this.powered) == this.powered && this.constructed != -1;
        }
        try {
            return this.getProxy().getEnergy().isNetworkPowered();
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    public boolean isFormed() {
        return this.constructed != -1;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE;
    }

    public void neighborUpdate() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public boolean hasQES() {
        if (this.constructed == -1) {
            return false;
        }
        return (this.constructed & this.hasSingularity) == this.hasSingularity;
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.destroy();
        }
    }

    public byte getCorner() {
        return this.corner;
    }
}

