/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemHandlerIterator;
import appeng.util.inv.ItemSlot;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class AdaptorItemHandler
extends InventoryAdaptor {
    private final IItemHandler itemHandler;

    public AdaptorItemHandler(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack rv = null;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            ItemStack extracted;
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is == null || filter != null && !Platform.isSameItemPrecise(is, filter) || destination != null && ((extracted = this.itemHandler.extractItem(slot, amount, true)) == null || !destination.canInsert(extracted)) || (extracted = this.itemHandler.extractItem(slot, amount, false)) == null) continue;
            if (rv == null) {
                rv = extracted;
                filter = extracted;
                amount -= extracted.field_77994_a;
                continue;
            }
            rv.field_77994_a += extracted.field_77994_a;
            amount -= extracted.field_77994_a;
        }
        return rv;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack rv = null;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            ItemStack extracted;
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is == null || filter != null && !Platform.isSameItemPrecise(is, filter) || (extracted = this.itemHandler.extractItem(slot, amount, true)) == null || destination != null && !destination.canInsert(extracted)) continue;
            if (rv == null) {
                rv = extracted.func_77946_l();
                filter = extracted;
                amount -= extracted.field_77994_a;
                continue;
            }
            rv.field_77994_a += extracted.field_77994_a;
            amount -= extracted.field_77994_a;
        }
        return rv;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack extracted = null;
        for (int slot = 0; slot < slots && extracted == null; ++slot) {
            ItemStack simulated;
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is == null || filter != null && !Platform.isSameItemFuzzy(is, filter, fuzzyMode) || destination != null && ((simulated = this.itemHandler.extractItem(slot, amount, true)) == null || !destination.canInsert(simulated))) continue;
            extracted = this.itemHandler.extractItem(slot, amount, false);
        }
        return extracted;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int slots = this.itemHandler.getSlots();
        ItemStack extracted = null;
        for (int slot = 0; slot < slots && extracted == null; ++slot) {
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is == null || filter != null && !Platform.isSameItemFuzzy(is, filter, fuzzyMode) || (extracted = this.itemHandler.extractItem(slot, amount, true)) == null || destination == null || destination.canInsert(extracted)) continue;
            extracted = null;
        }
        return extracted;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, false);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.addItems(toBeSimulated, true);
    }

    private ItemStack addItems(ItemStack itemsToAdd, boolean simulate) {
        if (itemsToAdd == null || itemsToAdd.field_77994_a == 0) {
            return null;
        }
        ItemStack left = itemsToAdd.func_77946_l();
        for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            ItemStack is = this.itemHandler.getStackInSlot(slot);
            if (is != null && !Platform.isSameItemPrecise(is, left) || (left = this.itemHandler.insertItem(slot, left, simulate)) != null && left.field_77994_a > 0) continue;
            return null;
        }
        return left;
    }

    @Override
    public boolean containsItems() {
        int slots = this.itemHandler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (this.itemHandler.getStackInSlot(slot) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new ItemHandlerIterator(this.itemHandler);
    }
}

