/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings;

import java.util.List;
import lumien.randomthings.CommonProxy;
import lumien.randomthings.RTCommand;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.client.GuiHandler;
import lumien.randomthings.config.ModConfiguration;
import lumien.randomthings.container.SyncHandler;
import lumien.randomthings.entitys.ModEntitys;
import lumien.randomthings.handler.ModDimensions;
import lumien.randomthings.handler.RTEventHandler;
import lumien.randomthings.handler.magicavoxel.ServerModelLibrary;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.lib.RTCreativeTab;
import lumien.randomthings.network.PacketHandler;
import lumien.randomthings.potion.ModPotions;
import lumien.randomthings.recipes.ModRecipes;
import lumien.randomthings.tileentity.ModTileEntitys;
import lumien.randomthings.tileentity.TileEntityEnderAnchor;
import lumien.randomthings.worldgen.WorldGenCores;
import lumien.randomthings.worldgen.WorldGenPlants;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="randomthings", name="Random Things", version="3.7.6", acceptedMinecraftVersions="[1.10.2]")
public class RandomThings
implements ForgeChunkManager.LoadingCallback {
    @Mod.Instance(value="randomthings")
    public static RandomThings instance;
    @SidedProxy(clientSide="lumien.randomthings.client.ClientProxy", serverSide="lumien.randomthings.CommonProxy")
    public static CommonProxy proxy;
    public RTCreativeTab creativeTab;
    public Logger logger;
    public ModConfiguration configuration;
    ASMDataTable asmDataTable;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.asmDataTable = event.getAsmData();
        this.creativeTab = new RTCreativeTab();
        this.logger = event.getModLog();
        this.configuration = new ModConfiguration();
        this.configuration.preInit(event);
        ModBlocks.load(event);
        ModItems.load(event);
        ModTileEntitys.register();
        ModEntitys.init();
        ModPotions.preInit(event);
        proxy.registerModels();
        RTEventHandler eventHandler = new RTEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        PacketHandler.init();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModRecipes.register();
        ModDimensions.register();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlants(), (int)1000);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenCores(), (int)1000);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.registerRenderers();
        SyncHandler.postInit(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new RTCommand());
        ServerModelLibrary.getInstance().refresh();
    }

    public ASMDataTable getASMData() {
        return this.asmDataTable;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket t : tickets) {
            NBTTagCompound compound = t.getModData();
            TileEntity te = world.func_175625_s(new BlockPos(compound.func_74762_e("posX"), compound.func_74762_e("posY"), compound.func_74762_e("posZ")));
            if (te == null || !(te instanceof TileEntityEnderAnchor)) continue;
            TileEntityEnderAnchor anchor = (TileEntityEnderAnchor)te;
            anchor.setTicket(t);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)t, (ChunkPos)world.func_175726_f(anchor.func_174877_v()).func_76632_l());
        }
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

