/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import java.util.Random;
import lumien.randomthings.RandomThings;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.handler.EnderLetterHandler;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.tileentity.TileEntityEnderMailbox;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnderMailbox
extends BlockContainerBase {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    protected static final AxisAlignedBB MAILBOX_SN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.0625, 0.6875, 1.375, 0.9375);
    protected static final AxisAlignedBB MAILBOX_WE_AABB = new AxisAlignedBB(0.0625, 0.0, 0.3125, 0.9375, 1.375, 0.6875);

    protected BlockEnderMailbox() {
        super("enderMailbox", Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.SOUTH || facing == EnumFacing.NORTH) {
            return MAILBOX_SN_AABB;
        }
        return MAILBOX_WE_AABB;
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            for (int i = 0; i < 4; ++i) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                int j = rand.nextInt(2) * 2 - 1;
                if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                    d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                    d3 = rand.nextFloat() * 2.0f * (float)j;
                } else {
                    d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                    d5 = rand.nextFloat() * 2.0f * (float)j;
                }
                worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (playerIn.func_70093_af() && heldItem != null && heldItem.func_77973_b() == ModItems.enderLetter) {
                NBTTagCompound compound = heldItem.func_77978_p();
                if (compound != null && compound.func_74764_b("receiver") && !compound.func_74767_n("received")) {
                    GameProfile playerProfile = worldIn.func_73046_m().func_152358_ax().func_152655_a(compound.func_74779_i("receiver"));
                    if (playerProfile != null && playerProfile.getId() != null) {
                        EnderLetterHandler.EnderMailboxInventory mailboxInventory = EnderLetterHandler.get(worldIn).getOrCreateInventoryForPlayer(playerProfile.getId());
                        for (int slot = 0; slot < mailboxInventory.func_70302_i_(); ++slot) {
                            if (mailboxInventory.func_70301_a(slot) != null) continue;
                            ItemStack sendingLetter = heldItem.func_77946_l();
                            heldItem.field_77994_a = 0;
                            sendingLetter.func_77978_p().func_74757_a("received", true);
                            sendingLetter.func_77978_p().func_74778_a("sender", playerIn.func_146103_bH().getName());
                            mailboxInventory.func_70299_a(slot, sendingLetter);
                            playerIn.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            return true;
                        }
                        playerIn.func_146105_b(new TextComponentTranslation("item.enderLetter.noSpace", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)));
                    } else {
                        playerIn.func_146105_b(new TextComponentTranslation("item.enderLetter.noPlayer", new Object[]{compound.func_74779_i("receiver")}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)));
                    }
                }
                return true;
            }
            TileEntityEnderMailbox te = (TileEntityEnderMailbox)worldIn.func_175625_s(pos);
            if (te.getOwner() != null) {
                if (te.getOwner().equals(playerIn.func_146103_bH().getId())) {
                    playerIn.openGui((Object)RandomThings.instance, 9, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                } else {
                    playerIn.func_146105_b(new TextComponentTranslation("block.enderMailbox.owner", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos.func_177984_a()) && super.func_176196_c(worldIn, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        boolean active;
        if (meta > 5) {
            active = true;
            meta -= 6;
        } else {
            active = false;
        }
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 6 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        if (!worldIn.field_72995_K && placer instanceof EntityPlayer) {
            TileEntityEnderMailbox te = (TileEntityEnderMailbox)worldIn.func_175625_s(pos);
            te.setOwner(((EntityPlayer)placer).func_146103_bH().getId());
        }
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityEnderMailbox();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

