/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.client.models.blocks;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lumien.randomthings.client.RenderReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class ModelCubeAll
implements IBakedModel {
    TextureAtlasSprite texture;
    boolean isAmbientOcclusion;
    List<BakedQuad> generalQuads;
    Map<EnumFacing, List<BakedQuad>> faceQuads;

    public ModelCubeAll(TextureAtlasSprite texture, boolean isAmbientOcclusion) {
        this.texture = texture;
        this.isAmbientOcclusion = isAmbientOcclusion;
        this.generalQuads = new ArrayList<BakedQuad>();
        this.faceQuads = new HashMap<EnumFacing, List<BakedQuad>>();
        for (EnumFacing f : EnumFacing.values()) {
            ArrayList<BakedQuad> faceQuadList = new ArrayList<BakedQuad>();
            this.faceQuads.put(f, faceQuadList);
            BakedQuad quad = this.createSidedBakedQuad(0.0f, 1.0f, 0.0f, 1.0f, 1.0f, this.func_177554_e(), f);
            this.generalQuads.add(quad);
            faceQuadList.add(quad);
        }
    }

    private int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v, EnumFacing side) {
        int xN = (byte)(side.func_82601_c() * 127) & 0xFF;
        int yN = (byte)(side.func_96559_d() * 127) & 0xFF;
        int zN = (byte)(side.func_82599_e() * 127) & 0xFF;
        int normal = xN | yN << 8 | zN << 16;
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), normal};
    }

    private BakedQuad createSidedBakedQuad(float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, EnumFacing side) {
        Vec3d v1 = ModelCubeAll.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v2 = ModelCubeAll.rotate(new Vec3d((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v3 = ModelCubeAll.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        Vec3d v4 = ModelCubeAll.rotate(new Vec3d((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).func_72441_c(0.5, 0.5, 0.5);
        return new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts((float)v1.field_72450_a, (float)v1.field_72448_b, (float)v1.field_72449_c, -1, texture, 0.0f, 0.0f, side), this.vertexToInts((float)v2.field_72450_a, (float)v2.field_72448_b, (float)v2.field_72449_c, -1, texture, 0.0f, 16.0f, side), this.vertexToInts((float)v3.field_72450_a, (float)v3.field_72448_b, (float)v3.field_72449_c, -1, texture, 16.0f, 16.0f, side), this.vertexToInts((float)v4.field_72450_a, (float)v4.field_72448_b, (float)v4.field_72449_c, -1, texture, 16.0f, 0.0f, side)}), -1, side, texture, false, DefaultVertexFormats.field_176599_b);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null) {
            return this.generalQuads;
        }
        return this.faceQuads.get(side);
    }

    public boolean func_177555_b() {
        return this.isAmbientOcclusion;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.texture;
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return RenderReference.BLOCK_ITEM_TRANSFORM;
    }

    private static Vec3d rotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
        }
        return null;
    }

    private static Vec3d revRotate(Vec3d vec, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d(vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
            }
            case UP: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case NORTH: {
                return new Vec3d(vec.field_72450_a, -vec.field_72449_c, vec.field_72448_b);
            }
            case SOUTH: {
                return new Vec3d(vec.field_72450_a, vec.field_72449_c, -vec.field_72448_b);
            }
            case WEST: {
                return new Vec3d(vec.field_72448_b, -vec.field_72450_a, vec.field_72449_c);
            }
            case EAST: {
                return new Vec3d(-vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
        }
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

