/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.util.List;
import lumien.randomthings.item.ItemBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ItemEntityFilter
extends ItemBase {
    public ItemEntityFilter() {
        super("entityFilter");
    }

    public static Class getEntityClass(ItemStack filter) {
        NBTTagCompound compound = filter.func_77978_p();
        if (compound != null) {
            if (compound.func_74767_n("modded")) {
                EntityRegistry.EntityRegistration registration;
                String modID = compound.func_74779_i("modID");
                int entityID = compound.func_74762_e("entityID");
                ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modID);
                if (modContainer != null && (registration = EntityRegistry.instance().lookupModSpawn(modContainer, entityID)) != null) {
                    return registration.getEntityClass();
                }
            } else {
                int entityID = compound.func_74762_e("entityID");
                return EntityList.func_90035_a((int)entityID);
            }
        }
        return null;
    }

    public static boolean filterAppliesTo(ItemStack filter, EntityLivingBase entity) {
        NBTTagCompound compound = filter.func_77978_p();
        if (compound != null) {
            if (compound.func_74767_n("modded")) {
                EntityRegistry.EntityRegistration registration;
                String modID = compound.func_74779_i("modID");
                int entityID = compound.func_74762_e("entityID");
                ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modID);
                if (modContainer != null && (registration = EntityRegistry.instance().lookupModSpawn(modContainer, entityID)) != null) {
                    return registration.getEntityClass().isAssignableFrom(entity.getClass());
                }
            } else {
                int entityID = compound.func_74762_e("entityID");
                return entityID == EntityList.func_75619_a((Entity)entity);
            }
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (!playerIn.field_70170_p.field_72995_K) {
            stack = playerIn.func_184614_ca();
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound compound = stack.func_77978_p();
            int vanillaEntityID = EntityList.func_75619_a((Entity)target);
            if (vanillaEntityID > 0) {
                compound.func_74757_a("modded", false);
                compound.func_74768_a("entityID", vanillaEntityID);
            } else {
                EntityRegistry.EntityRegistration registration = EntityRegistry.instance().lookupModSpawn(target.getClass(), false);
                if (registration != null) {
                    compound.func_74757_a("modded", true);
                    compound.func_74778_a("modID", registration.getContainer().getModId());
                    compound.func_74768_a("entityID", registration.getModEntityId());
                }
            }
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            String entityName = null;
            if (compound.func_74767_n("modded")) {
                EntityRegistry.EntityRegistration registration;
                String modID = compound.func_74779_i("modID");
                int entityID = compound.func_74762_e("entityID");
                ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modID);
                if (modContainer != null && (registration = EntityRegistry.instance().lookupModSpawn(modContainer, entityID)) != null) {
                    entityName = registration.getEntityName();
                }
            } else {
                int entityID = compound.func_74762_e("entityID");
                entityName = EntityList.func_188430_a((Class)EntityList.func_90035_a((int)entityID));
            }
            if (entityName != null) {
                tooltip.add(entityName);
            } else {
                tooltip.add(I18n.func_135052_a((String)"tooltip.entityFilter.invalidEntity", (Object[])new Object[0]));
            }
        }
    }
}

