/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.UUID;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityPlayerInterface
extends TileEntityBase
implements ISidedInventory,
ITickable {
    UUID playerUUID;
    EntityPlayerMP playerEntity;
    int[] armorSlots = new int[4];
    int[] hotbarSlots = new int[9];
    int[] mainSlots = new int[27];

    public TileEntityPlayerInterface() {
        int i = 0;
        int slot = 36;
        while (slot < 40) {
            this.armorSlots[i] = slot++;
            ++i;
        }
        i = 0;
        slot = 9;
        while (slot < 36) {
            this.mainSlots[i] = slot++;
            ++i;
        }
        i = 0;
        slot = 0;
        while (slot < 9) {
            this.hotbarSlots[i] = slot++;
            ++i;
        }
        this.playerUUID = null;
    }

    public EntityPlayer getPlayer() {
        return this.playerEntity;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.playerEntity == null && this.playerUUID != null) {
                EntityPlayerMP tempPlayer = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerUUID);
                if (tempPlayer != null) {
                    this.playerEntity = tempPlayer;
                    this.field_145850_b.func_180496_d(this.field_174879_c, (Block)ModBlocks.playerInterface);
                }
            } else {
                EntityPlayerMP tempPlayer = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerUUID);
                if (tempPlayer != this.playerEntity) {
                    this.playerEntity = null;
                    this.field_145850_b.func_180496_d(this.field_174879_c, (Block)ModBlocks.playerInterface);
                }
            }
        }
    }

    public void setPlayerUUID(UUID uuid) {
        this.playerUUID = uuid;
        this.func_70296_d();
        this.syncTE();
    }

    private void checkPlayerEntity() {
        if (this.playerEntity == null) {
            return;
        }
        if (this.playerEntity.field_70128_L) {
            this.playerEntity = null;
        }
    }

    public int func_70302_i_() {
        this.checkPlayerEntity();
        if (this.playerEntity == null) {
            return 0;
        }
        return this.playerEntity.field_71071_by.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        this.checkPlayerEntity();
        if (this.playerEntity == null) {
            return null;
        }
        return this.playerEntity.field_71071_by.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        this.checkPlayerEntity();
        if (this.playerEntity == null) {
            return null;
        }
        ItemStack newStack = this.playerEntity.field_71071_by.func_70298_a(i, j);
        this.playerEntity.field_71071_by.func_70296_d();
        return newStack;
    }

    public ItemStack func_70304_b(int i) {
        this.checkPlayerEntity();
        if (this.playerEntity == null) {
            return null;
        }
        return this.playerEntity.field_71071_by.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.checkPlayerEntity();
        if (this.playerEntity == null) {
            return;
        }
        this.playerEntity.field_71071_by.func_70299_a(i, itemstack);
        this.playerEntity.field_71071_by.func_70296_d();
    }

    public int func_70297_j_() {
        this.checkPlayerEntity();
        if (this.playerEntity == null) {
            return 0;
        }
        return this.playerEntity.field_71071_by.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        this.checkPlayerEntity();
        if (this.playerEntity != null) {
            this.playerEntity.field_71071_by.func_174889_b(player);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.checkPlayerEntity();
        if (this.playerEntity != null && this.playerEntity.field_71069_bz != null) {
            this.playerEntity.field_71069_bz.func_75142_b();
            this.playerEntity.func_71120_a(this.playerEntity.field_71069_bz);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        this.checkPlayerEntity();
        if (this.playerEntity != null) {
            this.playerEntity.field_71071_by.func_174886_c(player);
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        this.checkPlayerEntity();
        if (this.playerEntity == null || this.playerEntity.field_71069_bz == null || this.playerEntity.field_71071_by == null || this.playerEntity.field_71069_bz.func_75147_a((IInventory)this.playerEntity.field_71071_by, i) == null) {
            return false;
        }
        return this.playerEntity.field_71069_bz.func_75147_a((IInventory)this.playerEntity.field_71071_by, i).func_75214_a(itemstack);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound nbt) {
        if (this.playerUUID != null) {
            nbt.func_74778_a("player-uuid", this.playerUUID.toString());
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("player-uuid")) {
            this.playerUUID = UUID.fromString(nbt.func_74779_i("player-uuid"));
        }
    }

    public boolean hasPlayer() {
        return this.playerEntity != null;
    }

    public InventoryPlayer getPlayerInventory() {
        return this.playerEntity.field_71071_by;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int[] func_180463_a(EnumFacing side) {
        this.checkPlayerEntity();
        if (this.playerEntity == null) {
            return new int[0];
        }
        if (side == EnumFacing.DOWN) {
            return this.hotbarSlots;
        }
        if (side == EnumFacing.UP) {
            return this.armorSlots;
        }
        return this.mainSlots;
    }

    public boolean func_180462_a(int index, ItemStack itemstack, EnumFacing direction) {
        return this.func_94041_b(index, itemstack);
    }

    public boolean func_180461_b(int index, ItemStack itemstack, EnumFacing direction) {
        return this.func_94041_b(index, itemstack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public String func_70005_c_() {
        return "container.playerinterface";
    }
}

