/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.worldgen;

import java.util.Random;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.config.Worldgen;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.tileentity.TileEntitySpecialChest;
import lumien.randomthings.util.BlockPattern;
import lumien.randomthings.util.InventoryUtil;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCores
implements IWorldGenerator {
    public static BlockPattern natureCore;

    public WorldGenCores() {
        natureCore = new BlockPattern();
        IBlockState jungleLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jungleLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
        natureCore.addBlock(jungleLog, 0, 0, 0);
        natureCore.addBlock(jungleLog, 0, 2, 0);
        natureCore.addBlock(ModBlocks.natureCore.func_176223_P(), 0, 1, 0);
        natureCore.addBlock(jungleLog, -1, 0, -1);
        natureCore.addBlock(jungleLog, 1, 0, -1);
        natureCore.addBlock(jungleLog, -1, 0, 1);
        natureCore.addBlock(jungleLog, 1, 0, 1);
        natureCore.addBlock(jungleLog, 1, 1, 0);
        natureCore.addBlock(jungleLog, 0, 1, 1);
        natureCore.addBlock(jungleLog, 0, 1, -1);
        natureCore.addBlock(jungleLog, -1, 1, 0);
        natureCore.addBlock(jungleLog, -1, 2, -1);
        natureCore.addBlock(jungleLog, 1, 2, -1);
        natureCore.addBlock(jungleLog, -1, 2, 1);
        natureCore.addBlock(jungleLog, 1, 2, 1);
        natureCore.addBlock(jungleLeaves, 1, 0, 0);
        natureCore.addBlock(jungleLeaves, 0, 0, 1);
        natureCore.addBlock(jungleLeaves, 0, 0, -1);
        natureCore.addBlock(jungleLeaves, -1, 0, 0);
        natureCore.addBlock(jungleLeaves, -1, 1, -1);
        natureCore.addBlock(jungleLeaves, 1, 1, -1);
        natureCore.addBlock(jungleLeaves, -1, 1, 1);
        natureCore.addBlock(jungleLeaves, 1, 1, 1);
        natureCore.addBlock(jungleLeaves, 1, 2, 0);
        natureCore.addBlock(jungleLeaves, 0, 2, 1);
        natureCore.addBlock(jungleLeaves, 0, 2, -1);
        natureCore.addBlock(jungleLeaves, -1, 2, 0);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int x;
        BlockPos target;
        if (world.func_175624_G() != WorldType.field_180272_g && world.field_73011_w.getDimension() == 0 && (target = world.func_175672_r(new BlockPos(x = chunkX * 16 + random.nextInt(16), 40, z = chunkZ * 16 + random.nextInt(16)))) != null && target.func_177956_o() >= 0) {
            boolean generateNatureCore;
            Biome biome = world.func_180494_b(target);
            int natureMult = 30;
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
                natureMult -= 8;
            }
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPARSE)) {
                natureMult += 4;
            }
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
                natureMult -= 4;
            }
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
                natureMult += 2;
            }
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                natureMult += 10;
            }
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) {
                natureMult -= 8;
            }
            boolean bl = generateNatureCore = random.nextInt(18 * natureMult) == 0;
            if (!Worldgen.natureCore) {
                generateNatureCore = false;
            }
            if (generateNatureCore) {
                boolean canPlaceCore = true;
                for (int modX = -2; modX < 3; ++modX) {
                    block1: for (int modZ = -2; modZ < 3; ++modZ) {
                        for (int modY = 0; modY < 3; ++modY) {
                            BlockPos check = new BlockPos(target.func_177958_n() + modX, target.func_177956_o() + modY, target.func_177952_p() + modZ);
                            if (!WorldUtil.isValidPosition(check)) {
                                canPlaceCore = false;
                                continue block1;
                            }
                            if (world.func_175623_d(check.func_177977_b()) || !world.isSideSolid(check.func_177977_b(), EnumFacing.UP) || world.func_175623_d(check) || world.func_180495_p(check).func_177230_c().func_176200_f((IBlockAccess)world, check)) continue;
                            canPlaceCore = false;
                            continue block1;
                        }
                    }
                }
                if (canPlaceCore && generateNatureCore) {
                    this.placeNatureCore(random, world, target);
                }
            }
        }
    }

    private void placeNatureCore(Random random, World world, BlockPos target) {
        natureCore.place(world, target, 2);
        boolean placed = false;
        for (int modX = -5; modX < 6; ++modX) {
            for (int modZ = -5; modZ < 6; ++modZ) {
                BlockPos check = new BlockPos(target.func_177958_n() + modX, target.func_177956_o(), target.func_177952_p() + modZ);
                if (world.func_175623_d(check) || world.func_180495_p(check).func_177230_c().func_176200_f((IBlockAccess)world, check)) {
                    world.func_180501_a(check, ModBlocks.specialChest.func_176223_P(), 2);
                    TileEntitySpecialChest te = (TileEntitySpecialChest)world.func_175625_s(check);
                    te.func_70299_a(0, new ItemStack((Item)ModItems.beans, random.nextInt(2) + 1, 2));
                    if (random.nextBoolean()) {
                        te.func_70299_a(1, new ItemStack((Item)ModItems.beans, random.nextInt(20) + 5));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(2, new ItemStack(Items.field_151015_O, random.nextInt(20) + 5));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(3, new ItemStack(Items.field_151014_N, random.nextInt(20) + 5));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(4, new ItemStack(Items.field_151080_bb, random.nextInt(15) + 2));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(5, new ItemStack(Items.field_151081_bc, random.nextInt(15) + 2));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(6, new ItemStack(Items.field_151120_aE, random.nextInt(20) + 5));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(7, new ItemStack(Items.field_151174_bG, random.nextInt(20) + 5));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(8, new ItemStack(Items.field_151172_bF, random.nextInt(20) + 1));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(9, new ItemStack(Blocks.field_150345_g, random.nextInt(20) + 1, random.nextInt(6)));
                        if (random.nextBoolean()) {
                            te.func_70299_a(10, new ItemStack(Blocks.field_150345_g, random.nextInt(20) + 1, random.nextInt(6)));
                        }
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(11, new ItemStack(Blocks.field_150395_bd, random.nextInt(20) + 1));
                    }
                    if (random.nextBoolean()) {
                        te.func_70299_a(12, new ItemStack((Block)Blocks.field_150328_O, random.nextInt(20) + 1, random.nextInt(9)));
                    }
                    InventoryUtil.shuffleInventory(te);
                    placed = true;
                }
                if (placed) break;
            }
            if (placed) break;
        }
    }
}

