/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.integration;

import java.util.List;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;

public abstract class IntegrationModule {
    public abstract String getModID();

    public boolean versionCheck() {
        String pattern = this.versionPattern();
        if (pattern == null) {
            return true;
        }
        List modList = Loader.instance().getModList();
        int n = modList.size();
        for (int i = 0; i < n; ++i) {
            ModContainer mod = (ModContainer)modList.get(i);
            if (!mod.getModId().equals(this.getModID())) continue;
            try {
                VersionRange validVersions = VersionRange.createFromVersionSpec((String)pattern);
                DefaultArtifactVersion version = new DefaultArtifactVersion(mod.getVersion());
                return validVersions.containsVersion((ArtifactVersion)version);
            }
            catch (InvalidVersionSpecificationException e) {
                return false;
            }
        }
        return false;
    }

    protected String versionPattern() {
        return null;
    }

    public abstract void init() throws Throwable;

    public abstract void postInit();
}

