/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.balyware.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.tile.TileCounter;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockCounter
extends BlockKitchen {
    public static final PropertyBool FLIPPED = PropertyBool.func_177716_a((String)"flipped");

    public BlockCounter() {
        super(Material.field_151573_f);
        this.setRegistryName("cookingforblockheads", "counter");
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, FLIPPED});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing;
        switch (meta & 7) {
            case 0: {
                facing = EnumFacing.EAST;
                break;
            }
            case 1: {
                facing = EnumFacing.WEST;
                break;
            }
            case 2: {
                facing = EnumFacing.SOUTH;
                break;
            }
            default: {
                facing = EnumFacing.NORTH;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                meta = 0;
                break;
            }
            case WEST: {
                meta = 1;
                break;
            }
            case SOUTH: {
                meta = 2;
                break;
            }
            default: {
                meta = 3;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)FLIPPED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileCounter();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileCounter tileCounter;
        if (side == state.func_177229_b((IProperty)FACING) && (tileCounter = (TileCounter)world.func_175625_s(pos)) != null) {
            if (player.func_70093_af()) {
                tileCounter.getDoorAnimator().toggleForcedOpen();
                return true;
            }
            if (heldItem != null && tileCounter.getDoorAnimator().isForcedOpen()) {
                heldItem = ItemHandlerHelper.insertItemStacked((IItemHandler)tileCounter.getItemHandler(), (ItemStack)heldItem, (boolean)false);
                player.func_184611_a(hand, heldItem);
                return true;
            }
        }
        if (!world.field_72995_K) {
            player.openGui((Object)CookingForBlockheads.instance, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        double blockRotation = (double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5;
        boolean flipped = Math.abs(blockRotation - (double)((int)blockRotation)) < 0.5;
        super.func_180633_a(world, pos, state.func_177226_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(!flipped)), placer, stack);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileCounter tileEntity = (TileCounter)world.func_175625_s(pos);
        if (tileEntity != null) {
            ItemUtils.dropContent(world, pos, tileEntity.getItemHandler());
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + this.getRegistryName() + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }
}

