/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingConfig;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.TileSink;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockSink
extends BlockKitchen {
    public BlockSink() {
        super(Material.field_151575_d);
        this.setRegistryName("cookingforblockheads", "sink");
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileSink sink;
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)heldItem)) {
            FluidStack fluidStack = null;
            int amount = FluidContainerRegistry.getContainerCapacity((FluidStack)new FluidStack(FluidRegistry.WATER, 1000), (ItemStack)heldItem);
            if (CookingConfig.sinkRequiresWater) {
                TileSink sink2 = (TileSink)world.func_175625_s(pos);
                if (sink2 != null && sink2.getWaterAmount() >= amount) {
                    fluidStack = sink2.drain(null, amount, true);
                }
            } else {
                fluidStack = new FluidStack(FluidRegistry.WATER, amount);
            }
            if (fluidStack != null && fluidStack.amount >= amount) {
                ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)heldItem);
                if (filledContainer != null) {
                    if (heldItem.field_77994_a <= 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filledContainer);
                    } else if (player.field_71071_by.func_70441_a(filledContainer)) {
                        --heldItem.field_77994_a;
                    }
                }
                this.spawnParticles(world, pos, state);
            }
            return true;
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)heldItem)) {
            ItemStack emptyContainer;
            TileSink sink3;
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldItem);
            if (CookingConfig.sinkRequiresWater && (sink3 = (TileSink)world.func_175625_s(pos)) != null) {
                sink3.fill(null, fluidStack, true);
            }
            if ((emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)heldItem)) != null) {
                if (heldItem.field_77994_a <= 1) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, emptyContainer);
                } else if (player.field_71071_by.func_70441_a(emptyContainer)) {
                    --heldItem.field_77994_a;
                }
            }
            this.spawnParticles(world, pos, state);
            return true;
        }
        ItemStack resultStack = CookingRegistry.getSinkOutput(heldItem);
        if (resultStack != null) {
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            ItemStack newItem = resultStack.func_77946_l();
            if (tagCompound != null) {
                newItem.func_77982_d(tagCompound);
            }
            if (heldItem.field_77994_a <= 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newItem);
            } else if (player.field_71071_by.func_70441_a(newItem)) {
                --heldItem.field_77994_a;
            }
            this.spawnParticles(world, pos, state);
            return true;
        }
        if (CookingConfig.sinkRequiresWater && (sink = (TileSink)world.func_175625_s(pos)) != null && sink.getWaterAmount() < 1000) {
            return true;
        }
        this.spawnParticles(world, pos, state);
        return true;
    }

    private void spawnParticles(World world, BlockPos pos, IBlockState state) {
        float dripWaterX = 0.0f;
        float dripWaterZ = 0.0f;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                dripWaterZ = 0.25f;
                dripWaterX = -0.05f;
                break;
            }
            case SOUTH: {
                dripWaterX = 0.25f;
                break;
            }
            case WEST: {
                dripWaterX = 0.25f;
                dripWaterZ = 0.25f;
                break;
            }
            case EAST: {
                dripWaterZ = -0.05f;
            }
        }
        float particleX = (float)pos.func_177958_n() + 0.5f;
        float particleY = (float)pos.func_177956_o() + 1.25f;
        float particleZ = (float)pos.func_177952_p() + 0.5f;
        world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)particleX + (double)dripWaterX, (double)particleY - (double)0.45f, (double)particleZ + (double)dripWaterZ, 0.0, 0.0, 0.0, new int[0]);
        for (int i = 0; i < 5; ++i) {
            world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)particleX + Math.random() - 0.5, (double)particleY + Math.random() - 0.5, (double)particleZ + Math.random() - 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileSink();
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + this.getRegistryName() + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }
}

