/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import io.netty.buffer.ByteBuf;
import net.blay09.mods.cookingforblockheads.registry.RecipeStatus;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class FoodRecipeWithStatus {
    private final ItemStack outputItem;
    private final RecipeStatus status;

    public FoodRecipeWithStatus(ItemStack outputItem, RecipeStatus status) {
        this.outputItem = outputItem;
        this.status = status;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public RecipeStatus getStatus() {
        return this.status;
    }

    public static FoodRecipeWithStatus read(ByteBuf buf) {
        ItemStack outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        RecipeStatus status = RecipeStatus.fromId(buf.readByte());
        return new FoodRecipeWithStatus(outputItem, status);
    }

    public void write(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItem);
        buf.writeByte(this.status.ordinal());
    }
}

