/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.network.wrappers.SyncableInt;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEnergyInventoryBase
extends TileInventoryBase {
    public final SyncableInt energyStored = new SyncableInt(0, false, true);
    public EnergyStorage energyStorage = new EnergyStorage(0, 0, 0);

    @Override
    public void detectAndSendChanges(boolean forceSync) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.energyStored.value = this.energyStorage.getEnergyStored();
        super.detectAndSendChanges(forceSync);
    }

    @Override
    public void detectAndSendChangesToPlayer(boolean forceSync, EntityPlayerMP playerMP) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.energyStored.value = this.energyStorage.getEnergyStored();
        super.detectAndSendChangesToPlayer(forceSync, playerMP);
    }

    protected void setCapacityAndTransfer(int capacity, int receive, int extract) {
        this.energyStorage.setCapacity(capacity);
        this.energyStorage.setMaxReceive(receive);
        this.energyStorage.setMaxExtract(extract);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        super.writeDataToNBT(compound);
        this.energyStorage.writeToNBT(compound);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        super.readDataFromNBT(compound);
        this.energyStorage.readFromNBT(compound);
    }

    protected int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    protected int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int sendEnergyTo(EnumFacing direction) {
        if (this.getEnergyStored() == 0) {
            return 0;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e()));
        if (tile instanceof IEnergyReceiver) {
            return this.energyStorage.extractEnergy(((IEnergyReceiver)tile).receiveEnergy(direction.func_176734_d(), this.energyStorage.extractEnergy(this.energyStorage.getMaxExtract(), true), false), false);
        }
        return 0;
    }

    public int sendEnergyToAll() {
        if (this.getEnergyStored() == 0) {
            return 0;
        }
        int i = 0;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            i += this.sendEnergyTo(direction);
        }
        return i;
    }

    public int extractEnergyFromItem(ItemStack stack, int maxExtract, boolean simulate) {
        if (stack != null && stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
            return item.extractEnergy(stack, maxExtract, simulate);
        }
        return 0;
    }
}

