/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IFOVModifierItem;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.network.PacketTickTime;
import com.brandon3055.brandonscore.network.PacketUpdateMount;
import com.brandon3055.brandonscore.utils.BCLogHelper;
import com.brandon3055.brandonscore.utils.LinkedHashList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BCClientEventHandler {
    private static int remountTicksRemaining = 0;
    private static int remountEntityID = 0;
    private static int debugTimeout = 0;
    private static Map<Integer, Integer[]> dimTickTimes = new HashMap<Integer, Integer[]>();
    private static Integer[] overallTickTime = new Integer[200];
    private static int renderIndex = 0;
    private static LinkedList<Integer> sortingOrder = new LinkedList();
    public static int elapsedTicks = 0;
    private static Comparator<Integer> sorter = new Comparator<Integer>(){

        @Override
        public int compare(Integer value, Integer compare) {
            long totalValue = 0L;
            for (Integer time : (Integer[])dimTickTimes.get(value)) {
                totalValue += (long)time.intValue();
            }
            totalValue /= 200L;
            long totalCompare = 0L;
            for (Integer time : (Integer[])dimTickTimes.get(compare)) {
                totalCompare += (long)time.intValue();
            }
            return totalValue > (totalCompare /= 200L) ? -1 : (totalValue < totalCompare ? 1 : 0);
        }
    };

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.searchForPlayerMount();
            if (debugTimeout > 0) {
                --debugTimeout;
            }
        }
        if (elapsedTicks % 100 == 0 && debugTimeout > 0) {
            sortingOrder.clear();
            sortingOrder.addAll(dimTickTimes.keySet());
            Collections.sort(sortingOrder, sorter);
        }
        ++elapsedTicks;
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerSP) {
            BrandonsCore.network.sendToServer((IMessage)new PacketUpdateMount(0));
        }
    }

    @SubscribeEvent
    public void renderScreen(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || debugTimeout <= 0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)600.0f);
        this.renderGraph(220, 0, event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), overallTickTime, "Overall");
        int i = 0;
        for (Integer dim : sortingOrder) {
            if (dimTickTimes.get(dim) == null || !DimensionManager.isDimensionRegistered((int)dim)) continue;
            DimensionType dimensionType = DimensionManager.getProviderType((int)dim);
            this.renderGraph(0, i, event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), dimTickTimes.get(dim), dimensionType == null ? dim.toString() : dimensionType.func_186065_b());
            ++i;
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void fovUpdate(FOVUpdateEvent event) {
        float originalFOV;
        EntityPlayer player = event.getEntity();
        float newFOV = originalFOV = event.getFov();
        int slotIndex = 2;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack != null && stack.func_77973_b() instanceof IFOVModifierItem) {
                newFOV = ((IFOVModifierItem)stack.func_77973_b()).getNewFOV(player, stack, newFOV, originalFOV, EntityEquipmentSlot.values()[slotIndex]);
            }
            ++slotIndex;
        }
        ItemStack stack = player.func_184592_cb();
        if (stack != null && stack.func_77973_b() instanceof IFOVModifierItem) {
            newFOV = ((IFOVModifierItem)stack.func_77973_b()).getNewFOV(player, stack, newFOV, originalFOV, EntityEquipmentSlot.OFFHAND);
        }
        if ((stack = player.func_184614_ca()) != null && stack.func_77973_b() instanceof IFOVModifierItem) {
            newFOV = ((IFOVModifierItem)stack.func_77973_b()).getNewFOV(player, stack, newFOV, originalFOV, EntityEquipmentSlot.MAINHAND);
        }
        if (newFOV != originalFOV) {
            event.setNewfov(newFOV);
        }
    }

    private void searchForPlayerMount() {
        if (remountTicksRemaining > 0) {
            Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(remountEntityID);
            if (e != null) {
                Minecraft.func_71410_x().field_71439_g.func_184220_m(e);
                BCLogHelper.info("Successfully placed player on mount after " + (500 - remountTicksRemaining) + " ticks");
                remountTicksRemaining = 0;
                return;
            }
            if (--remountTicksRemaining == 0) {
                BCLogHelper.error("Unable to locate player mount after 500 ticks! Aborting");
                BrandonsCore.network.sendToServer((IMessage)new PacketUpdateMount(-1));
            }
        }
    }

    public static void tryRepositionPlayerOnMount(int id) {
        if (remountTicksRemaining == 500) {
            return;
        }
        remountTicksRemaining = 500;
        remountEntityID = id;
        BCLogHelper.info("Started checking for player mount");
    }

    private void renderGraph(int x, int y, int screenWidth, int screenHeight, Integer[] times, String name) {
        int yHeight = screenHeight - 23 - y * 45;
        GuiHelper.drawColouredRect(x, yHeight - 34, 202, 32, -1442840576);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175065_a(name, (float)(x + 2), (float)(yHeight - 43), 0xFFFFFF, true);
        GuiHelper.drawBorderedRect(x, yHeight - 34, 202, 17, 1, 0x44AA0000, -1429418804);
        GuiHelper.drawBorderedRect(x, yHeight - 18, 202, 17, 1, 0x4400AA00, -1429418804);
        fontRenderer.func_78276_b("50ms", x + 2, yHeight - 16, 0xFFFFFF);
        fontRenderer.func_78276_b("100ms", x + 2, yHeight - 32, 0xFFFFFF);
        for (int i = 0; i < 200; ++i) {
            int time = times[i] == null ? 0 : times[i];
            int height = (int)((double)time / 100.0 / 100.0 * 30.0);
            int j1 = BCClientEventHandler.getFrameColor(MathHelper.func_76125_a((int)height, (int)0, (int)30), 0, 15, 30);
            GuiHelper.drawColouredRect(x + (i - renderIndex) % 200 + 200, yHeight - 2 - height, 1, height, j1);
        }
    }

    public static void handleTickPacket(PacketTickTime packet) {
        debugTimeout = 500;
        BCClientEventHandler.overallTickTime[++BCClientEventHandler.renderIndex % 200] = packet.overall;
        LinkedHashList<Integer> dims = new LinkedHashList<Integer>();
        dims.addAll(dimTickTimes.keySet());
        for (Integer dim : packet.tickTimes.keySet()) {
            if (!dimTickTimes.containsKey(dim)) {
                Integer[] ints = new Integer[200];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = 0;
                }
                dimTickTimes.put(dim, ints);
            }
            BCClientEventHandler.dimTickTimes.get((Object)dim)[BCClientEventHandler.renderIndex % 200] = packet.tickTimes.get(dim);
            if (!dims.contains(dim)) continue;
            dims.remove(dim);
        }
        if (!dims.isEmpty()) {
            block2: while (dims.size() > 0) {
                for (Integer i : dimTickTimes.keySet()) {
                    if (!((Integer)dims.get(0)).equals(i)) continue;
                    dimTickTimes.remove(i);
                    dims.remove(0);
                    continue block2;
                }
            }
            sortingOrder.clear();
            sortingOrder.addAll(dimTickTimes.keySet());
            Collections.sort(sortingOrder, sorter);
        }
    }

    public static int getFrameColor(int input, int min, int mid, int max) {
        return input < mid ? BCClientEventHandler.blendColors(-16711936, -256, (float)input / (float)mid) : BCClientEventHandler.blendColors(-256, -65536, (float)(input - mid) / (float)(max - mid));
    }

    public static int blendColors(int p_181553_1_, int p_181553_2_, float p_181553_3_) {
        int i = p_181553_1_ >> 24 & 0xFF;
        int j = p_181553_1_ >> 16 & 0xFF;
        int k = p_181553_1_ >> 8 & 0xFF;
        int l = p_181553_1_ & 0xFF;
        int i1 = p_181553_2_ >> 24 & 0xFF;
        int j1 = p_181553_2_ >> 16 & 0xFF;
        int k1 = p_181553_2_ >> 8 & 0xFF;
        int l1 = p_181553_2_ & 0xFF;
        int i2 = MathHelper.func_76125_a((int)((int)((float)i + (float)(i1 - i) * p_181553_3_)), (int)0, (int)255);
        int j2 = MathHelper.func_76125_a((int)((int)((float)j + (float)(j1 - j) * p_181553_3_)), (int)0, (int)255);
        int k2 = MathHelper.func_76125_a((int)((int)((float)k + (float)(k1 - k) * p_181553_3_)), (int)0, (int)255);
        int l2 = MathHelper.func_76125_a((int)((int)((float)l + (float)(l1 - l) * p_181553_3_)), (int)0, (int)255);
        return i2 << 24 | j2 << 16 | k2 << 8 | l2;
    }
}

