/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.particle;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.lib.PairKV;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Callable;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BCEffectRenderer {
    public World worldObj;
    private final Random rand = new Random();
    private final Map<ResourceLocation, ArrayDeque<Particle>[][]> texturedRenderQueue = new HashMap<ResourceLocation, ArrayDeque<Particle>[][]>();
    private final Queue<PairKV<ResourceLocation, Particle>> queueTexturedParticle = new ArrayDeque<PairKV<ResourceLocation, Particle>>();

    public BCEffectRenderer(World worldObj) {
        this.worldObj = worldObj;
    }

    public void addEffect(ResourceLocation resourceLocation, Particle Particle2) {
        if (resourceLocation == null || Particle2 == null) {
            return;
        }
        this.queueTexturedParticle.add(new PairKV<ResourceLocation, Particle>(resourceLocation, Particle2));
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            this.updateEffectLayer(i);
        }
        if (!this.queueTexturedParticle.isEmpty()) {
            PairKV<ResourceLocation, Particle> entry = this.queueTexturedParticle.poll();
            while (entry != null) {
                Object o;
                int mask;
                ArrayDeque[][] array;
                if (!this.texturedRenderQueue.containsKey(entry.getKey())) {
                    array = new ArrayDeque[4][];
                    for (int i = 0; i < 4; ++i) {
                        array[i] = new ArrayDeque[2];
                        for (int j = 0; j < 2; ++j) {
                            array[i][j] = new ArrayDeque();
                        }
                    }
                    this.texturedRenderQueue.put(entry.getKey(), array);
                }
                array = this.texturedRenderQueue.get(entry.getKey());
                Particle Particle2 = entry.getValue();
                int layer = Particle2.func_70537_b();
                int n = mask = Particle2.func_187111_c() ? 0 : 1;
                if (array[layer][mask].size() >= 6000 && (o = array[layer][mask].removeFirst()) instanceof Particle) {
                    ((Particle)o).func_187112_i();
                }
                array[layer][mask].add(Particle2);
                entry = this.queueTexturedParticle.poll();
            }
        }
    }

    private void updateEffectLayer(int layer) {
        for (int i = 0; i < 2; ++i) {
            for (ArrayDeque<Particle>[][] queue : this.texturedRenderQueue.values()) {
                this.tickAndRemoveDead(queue[layer][i]);
            }
        }
    }

    private void tickAndRemoveDead(Queue<Particle> queue) {
        if (!queue.isEmpty()) {
            Iterator iterator = queue.iterator();
            while (iterator.hasNext()) {
                Particle Particle2 = (Particle)iterator.next();
                this.tickParticle(Particle2);
                if (Particle2.func_187113_k()) continue;
                iterator.remove();
            }
        }
    }

    public void clearEffects(World worldIn) {
        this.worldObj = worldIn;
        for (ArrayDeque<Particle>[][] array : this.texturedRenderQueue.values()) {
            for (int layer = 0; layer < 4; ++layer) {
                for (int mask = 0; mask < 2; ++mask) {
                    array[layer][mask].clear();
                }
            }
        }
    }

    private void tickParticle(final Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
            final int i = particle.func_70537_b();
            crashreportcategory.func_71507_a("Particle", (Object)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return particle.toString();
                }
            });
            crashreportcategory.func_71507_a("Particle Type", (Object)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return i == 0 ? "MISC_TEXTURE" : (i == 1 ? "TERRAIN_TEXTURE" : (i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i));
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        Tessellator tessellator = Tessellator.func_178181_a();
        for (int layer = 0; layer < 4; ++layer) {
            this.renderTexturedParticlesInLayer(layer, tessellator, entityIn, partialTicks, f, f1, f2, f3, f4);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    private void renderParticlesInLayer(int layer, Tessellator tessellator, Entity entityIn, float partialTicks, float f, float f1, float f2, float f3, float f4) {
    }

    private void renderTexturedParticlesInLayer(int layer, Tessellator tessellator, Entity entityIn, float partialTicks, float f, float f1, float f2, float f3, float f4) {
        for (ResourceLocation resourceLocation : this.texturedRenderQueue.keySet()) {
            ResourceHelperBC.bindTexture(resourceLocation);
            ArrayDeque<Particle>[][] texRenderQueue = this.texturedRenderQueue.get(resourceLocation);
            for (int j = 0; j < 2; ++j) {
                final int i_f = layer;
                if (texRenderQueue[layer][j].isEmpty()) continue;
                switch (j) {
                    case 0: {
                        GlStateManager.func_179132_a((boolean)false);
                        GlStateManager.func_179092_a((int)516, (float)0.0f);
                        break;
                    }
                    case 1: {
                        GlStateManager.func_179132_a((boolean)true);
                    }
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                VertexBuffer vertexbuffer = tessellator.func_178180_c();
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                for (final Particle Particle2 : texRenderQueue[layer][j]) {
                    try {
                        Particle2.func_180434_a(vertexbuffer, entityIn, partialTicks, f, f4, f1, f2, f3);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                        crashreportcategory.func_71507_a("Particle", (Object)new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return Particle2.toString();
                            }
                        });
                        crashreportcategory.func_71507_a("Particle Type", (Object)new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return i_f == 0 ? "MISC_TEXTURE" : (i_f == 1 ? "TERRAIN_TEXTURE" : (i_f == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i_f));
                            }
                        });
                        throw new ReportedException(crashreport);
                    }
                }
                tessellator.func_78381_a();
            }
        }
    }

    public String getStatistics() {
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 2; ++k) {
                for (ArrayDeque<Particle>[][] list : this.texturedRenderQueue.values()) {
                    i += list[j][k].size();
                }
            }
        }
        return "" + i;
    }
}

