/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import com.brandon3055.brandonscore.utils.BCLogHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PlayerSlot {
    private int slot;
    private EnumInvCategory category;

    public PlayerSlot(int slot, EnumInvCategory category) {
        this.slot = slot;
        this.category = category;
    }

    public void toBuff(ByteBuf buf) {
        buf.writeByte(this.category.getIndex());
        buf.writeByte(this.slot);
    }

    public static PlayerSlot fromBuff(ByteBuf buf) {
        EnumInvCategory category = EnumInvCategory.fromIndex(buf.readByte());
        byte slot = buf.readByte();
        return new PlayerSlot(slot, category);
    }

    public ItemStack getStackInSlot(EntityPlayer player) {
        ItemStack[] stacks;
        if (this.category == EnumInvCategory.ARMOR) {
            stacks = player.field_71071_by.field_70460_b;
        } else if (this.category == EnumInvCategory.MAIN) {
            stacks = player.field_71071_by.field_70462_a;
        } else if (this.category == EnumInvCategory.OFF_HAND) {
            stacks = player.field_71071_by.field_184439_c;
        } else {
            BCLogHelper.bigError("PlayerSlot#getStackInSlot Invalid or null category! This should not be possible! [%s]... Fix your Shit!", new Object[]{this.category});
            return null;
        }
        if (this.slot < 0 || this.slot >= stacks.length) {
            BCLogHelper.bigError("PlayerSlot#getStackInSlot Hay! I just saved you an index out of bounds! Be grateful and fix your shit!", new Object[0]);
            return null;
        }
        return stacks[this.slot];
    }

    public static enum EnumInvCategory {
        MAIN(0),
        ARMOR(1),
        OFF_HAND(2);

        private int index;
        private static EnumInvCategory[] indexMap;

        private EnumInvCategory(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumInvCategory fromIndex(int index) {
            if (index > 2 || index < 0) {
                BCLogHelper.bigError("PlayerSlot.EnumInvCategory#fromIndex Attempt to read invalid index! [%s]", index);
                return indexMap[0];
            }
            return indexMap[index];
        }

        static {
            indexMap = new EnumInvCategory[3];
            EnumInvCategory.indexMap[0] = MAIN;
            EnumInvCategory.indexMap[1] = ARMOR;
            EnumInvCategory.indexMap[2] = OFF_HAND;
        }
    }
}

