/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.items;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemEnergyBase
extends ItemBCore
implements IEnergyContainerItem {
    private int capacity;
    private int receive;
    private int extract;

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn));
        ItemStack stack = new ItemStack(itemIn);
        this.setEnergy(stack, this.getCapacity(stack));
        subItems.add(stack);
    }

    public void setEnergyStats(int capacity, int receive, int extract) {
        this.capacity = capacity;
        this.receive = receive;
        this.extract = extract;
    }

    public int getCapacity(ItemStack stack) {
        return this.capacity;
    }

    public int getMaxReceive(ItemStack stack) {
        return this.receive;
    }

    public int getMaxExtract(ItemStack stack) {
        return this.extract;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energy = ItemNBTHelper.getInteger(container, "Energy", 0);
        int energyReceived = Math.min(this.getCapacity(container) - energy, Math.min(this.getMaxReceive(container), maxReceive));
        if (!simulate) {
            ItemNBTHelper.setInteger(container, "Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int energy = ItemNBTHelper.getInteger(container, "Energy", 0);
        int energyExtracted = Math.min(energy, Math.min(this.getMaxExtract(container), maxExtract));
        if (!simulate) {
            ItemNBTHelper.setInteger(container, "Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInteger(container, "Energy", 0);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.getCapacity(container);
    }

    public void setEnergy(ItemStack container, int energy) {
        if (energy > this.getCapacity(container)) {
            energy = this.getCapacity(container);
        } else if (energy < 0) {
            energy = 0;
        }
        ItemNBTHelper.setInteger(container, "Energy", energy);
    }

    public void modifyEnergy(ItemStack container, int modify) {
        int energy = ItemNBTHelper.getInteger(container, "Energy", 0);
        if ((energy += modify) > this.getCapacity(container)) {
            energy = this.getCapacity(container);
        } else if (energy < 0) {
            energy = 0;
        }
        ItemNBTHelper.setInteger(container, "Energy", energy);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        InfoHelper.addEnergyInfo(stack, tooltip);
    }
}

