/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network.wrappers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.utils.BCLogHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SyncableLong
extends SyncableObject {
    public long value;
    public long lastTickValue;

    public SyncableLong(long value, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        this.value = this.lastTickValue = value;
    }

    public SyncableLong(long value, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.value = this.lastTickValue = value;
    }

    @Override
    public void detectAndSendChanges(TileBCBase tile, EntityPlayer player, boolean forceSync) {
        if (this.lastTickValue != this.value || forceSync) {
            this.lastTickValue = this.value;
            tile.dirtyBlock();
            if (player == null) {
                BrandonsCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                BrandonsCore.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), (EntityPlayerMP)player);
            } else {
                BCLogHelper.error("SyncableInt#detectAndSendChanges No valid destination for sync packet!");
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 8) {
            this.value = packet.longValue;
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74772_a("SyncableLong" + this.index, this.value);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("SyncableLong" + this.index)) {
            this.value = compound.func_74763_f("SyncableLong" + this.index);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

